/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.thoughtworks.selenium.SeleniumException;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;
import org.openqa.selenium.internal.seleniumemulation.SeleniumSelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindFirstSelectedOptionProperty
extends SeleneseCommand<String> {
    private final JavascriptLibrary library;
    private final ElementFinder finder;
    private final String property;

    public FindFirstSelectedOptionProperty(JavascriptLibrary library, ElementFinder finder, String property) {
        this.library = library;
        this.finder = finder;
        this.property = property;
    }

    @Override
    protected String handleSeleneseCommand(WebDriver driver, String selectLocator, String ignored) {
        SeleniumSelect select = new SeleniumSelect(this.library, this.finder, driver, selectLocator);
        List<WebElement> allOptions = select.getSelectedOptions();
        if (allOptions.isEmpty()) {
            throw new SeleniumException("No options are selected: " + selectLocator);
        }
        return allOptions.get(0).getAttribute(this.property);
    }
}

