/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonInputIterator;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class MapCoercer<T>
extends TypeCoercer<T> {
    private final Class<T> stereotype;
    private final JsonTypeCoercer coercer;
    private final Collector<Map.Entry<?, ?>, ?, ? extends T> collector;

    public MapCoercer(Class<T> stereotype, JsonTypeCoercer coercer, Collector<Map.Entry<?, ?>, ?, ? extends T> collector) {
        this.stereotype = stereotype;
        this.coercer = coercer;
        this.collector = collector;
    }

    @Override
    public boolean test(Class<?> type) {
        return this.stereotype.isAssignableFrom(type);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type type) {
        Object valueType;
        Object keyType;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            keyType = pt.getActualTypeArguments()[0];
            valueType = pt.getActualTypeArguments()[1];
        } else if (type instanceof Class) {
            keyType = Object.class;
            valueType = Object.class;
        } else {
            throw new IllegalArgumentException("Unhandled type: " + type.getClass());
        }
        return (arg_0, arg_1) -> this.lambda$apply$1((Type)keyType, valueType, arg_0, arg_1);
    }

    private /* synthetic */ Object lambda$apply$1(Type keyType, Type valueType, JsonInput jsonInput, PropertySetting setting) {
        jsonInput.beginObject();
        T toReturn = new JsonInputIterator(jsonInput).asStream().map(in -> {
            Object key = this.coercer.coerce((JsonInput)in, keyType, setting);
            Object value = this.coercer.coerce((JsonInput)in, valueType, setting);
            return new AbstractMap.SimpleImmutableEntry(key, value);
        }).collect(this.collector);
        jsonInput.endObject();
        return toReturn;
    }
}

