/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DaemonExecutor;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.CircularOutputStream;
import org.openqa.selenium.io.MultiOutputStream;
import org.openqa.selenium.os.ExecutableFinder;

@Deprecated
class OsProcess {
    private static final Logger LOG = Logger.getLogger(OsProcess.class.getName());
    private final CircularOutputStream inputOut = new CircularOutputStream(32768);
    private volatile String allInput;
    private final DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
    private final Executor executor = new DaemonExecutor();
    private volatile OutputStream drainTo;
    private final SeleniumWatchDog executeWatchdog = new SeleniumWatchDog(-1L);
    private PumpStreamHandler streamHandler;
    private final CommandLine cl;
    private final Map<String, String> env = new ConcurrentHashMap<String, String>();

    public OsProcess(String executable, String ... args) {
        String actualExe = new ExecutableFinder().find(executable);
        Require.state((String)"Actual executable", (Object)actualExe).nonNull("Unable to find executable for: %s", new Object[]{executable});
        this.cl = new CommandLine(actualExe);
        this.cl.addArguments(args, false);
    }

    public void setEnvironmentVariable(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot have a null environment variable name!");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot have a null value for environment variable " + name);
        }
        this.env.put(name, value);
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(new HashMap<String, String>(this.env));
    }

    private Map<String, String> getMergedEnv() {
        HashMap<String, String> newEnv = new HashMap<String, String>(System.getenv());
        newEnv.putAll(this.env);
        return newEnv;
    }

    private ByteArrayInputStream getInputStream() {
        return this.allInput != null ? new ByteArrayInputStream(this.allInput.getBytes(Charset.defaultCharset())) : null;
    }

    public void executeAsync() {
        try {
            OutputStream outputStream = this.getOutputStream();
            this.executeWatchdog.reset();
            this.executor.setWatchdog((ExecuteWatchdog)this.executeWatchdog);
            this.streamHandler = new PumpStreamHandler(outputStream, outputStream, (InputStream)this.getInputStream());
            this.executor.setStreamHandler((ExecuteStreamHandler)this.streamHandler);
            this.executor.execute(this.cl, this.getMergedEnv(), (ExecuteResultHandler)this.handler);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public boolean waitForProcessStarted(long duration, TimeUnit unit) {
        return this.executeWatchdog.waitForProcessStarted(duration, unit);
    }

    private OutputStream getOutputStream() {
        return this.drainTo == null ? this.inputOut : new MultiOutputStream(this.inputOut, this.drainTo);
    }

    public int destroy() {
        SeleniumWatchDog watchdog = this.executeWatchdog;
        if (watchdog.waitForProcessStarted(2L, TimeUnit.MINUTES)) {
            if (!Platform.getCurrent().is(Platform.WINDOWS)) {
                watchdog.destroyProcess();
                watchdog.waitForTerminationAfterDestroy(2, TimeUnit.SECONDS);
            }
            if (this.isRunning()) {
                watchdog.destroyHarder();
                watchdog.waitForTerminationAfterDestroy(1, TimeUnit.SECONDS);
            }
        } else {
            LOG.warning("Tried to destory a process which never started.");
        }
        if (this.streamHandler != null) {
            this.streamHandler.setStopTimeout(2000L);
            try {
                this.streamHandler.stop();
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Unable to drain process streams. Ignoring but the exception being swallowed follows.", e);
            }
        }
        if (!this.isRunning()) {
            return this.getExitCode();
        }
        LOG.severe(String.format("Unable to kill process %s", watchdog.process));
        int exitCode = -1;
        this.executor.setExitValue(exitCode);
        return exitCode;
    }

    public void waitFor() throws InterruptedException {
        this.handler.waitFor();
    }

    public void waitFor(long timeout) throws InterruptedException {
        long until = System.currentTimeMillis() + timeout;
        boolean timedOut = true;
        while (System.currentTimeMillis() < until) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.handler.hasResult()) {
                timedOut = false;
                break;
            }
            Thread.sleep(50L);
        }
        if (timedOut) {
            throw new TimeoutException(String.format("Process timed out after waiting for %d ms.", timeout));
        }
    }

    public boolean isRunning() {
        return !this.handler.hasResult();
    }

    public int getExitCode() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot get exit code before executing command line: " + this.cl);
        }
        return this.handler.getExitValue();
    }

    public void checkForError() {
        if (this.handler.getException() != null) {
            LOG.severe(this.handler.getException().toString());
        }
    }

    public String getStdOut() {
        return this.inputOut.toString();
    }

    public void setInput(String allInput) {
        this.allInput = allInput;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.executor.setWorkingDirectory(workingDirectory);
    }

    public String toString() {
        return this.cl.toString() + "[ " + this.env + "]";
    }

    public void copyOutputTo(OutputStream out) {
        this.drainTo = out;
    }

    class SeleniumWatchDog
    extends ExecuteWatchdog {
        private volatile Process process;
        private volatile boolean starting;

        SeleniumWatchDog(long timeout) {
            super(timeout);
            this.starting = true;
        }

        public synchronized void start(Process process) {
            this.process = process;
            this.starting = false;
            super.start(process);
        }

        public void reset() {
            this.starting = true;
        }

        private boolean waitForProcessStarted(long duration, TimeUnit unit) {
            long end = System.currentTimeMillis() + unit.toMillis(duration);
            while (this.starting && System.currentTimeMillis() < end) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WebDriverException((Throwable)e);
                }
            }
            return !this.starting;
        }

        private void waitForTerminationAfterDestroy(int duration, TimeUnit unit) {
            long end = System.currentTimeMillis() + unit.toMillis(duration);
            while (OsProcess.this.isRunning() && System.currentTimeMillis() < end) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WebDriverException((Throwable)e);
                }
            }
        }

        private void destroyHarder() {
            try {
                Process awaitFor = this.process.destroyForcibly();
                awaitFor.waitFor(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

