/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;

public class HttpCommandExecutor
implements CommandExecutor {
    private final String remotePath;
    private Map<DriverCommand, CommandInfo> nameToUrl;
    private HttpClient client;

    public HttpCommandExecutor(URL addressOfRemoteServer) throws Exception {
        if (addressOfRemoteServer == null) {
            String remoteServer = System.getProperty("webdriver.remote.server");
            URL uRL = addressOfRemoteServer = remoteServer == null ? null : new URL(remoteServer);
            if (addressOfRemoteServer == null) {
                throw new IllegalArgumentException("You must specify a remote address to connect to");
            }
        }
        this.remotePath = addressOfRemoteServer.getPath();
        URI uri = new URI(addressOfRemoteServer.toString(), false);
        this.client = new HttpClient();
        this.client.getHostConfiguration().setHost(uri);
        this.nameToUrl = ImmutableMap.builder().put((Object)DriverCommand.NEW_SESSION, (Object)HttpCommandExecutor.post("/session")).put((Object)DriverCommand.QUIT, (Object)HttpCommandExecutor.delete("/session/:sessionId")).put((Object)DriverCommand.GET_CURRENT_WINDOW_HANDLE, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/window_handle")).put((Object)DriverCommand.GET_WINDOW_HANDLES, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/window_handles")).put((Object)DriverCommand.GET, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/url")).put((Object)DriverCommand.GO_FORWARD, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/forward")).put((Object)DriverCommand.GO_BACK, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/back")).put((Object)DriverCommand.REFRESH, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/refresh")).put((Object)DriverCommand.EXECUTE_SCRIPT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/execute")).put((Object)DriverCommand.GET_CURRENT_URL, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/url")).put((Object)DriverCommand.GET_TITLE, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/title")).put((Object)DriverCommand.GET_PAGE_SOURCE, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/source")).put((Object)DriverCommand.SCREENSHOT, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/screenshot")).put((Object)DriverCommand.SET_BROWSER_VISIBLE, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/visible")).put((Object)DriverCommand.IS_BROWSER_VISIBLE, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/visible")).put((Object)DriverCommand.FIND_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element")).put((Object)DriverCommand.FIND_ELEMENTS, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/elements")).put((Object)DriverCommand.GET_ACTIVE_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/active")).put((Object)DriverCommand.FIND_CHILD_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/element/:using")).put((Object)DriverCommand.FIND_CHILD_ELEMENTS, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/elements/:using")).put((Object)DriverCommand.CLICK_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/click")).put((Object)DriverCommand.CLEAR_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/clear")).put((Object)DriverCommand.SUBMIT_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/submit")).put((Object)DriverCommand.GET_ELEMENT_TEXT, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/text")).put((Object)DriverCommand.SEND_KEYS_TO_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/value")).put((Object)DriverCommand.GET_ELEMENT_VALUE, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/value")).put((Object)DriverCommand.GET_ELEMENT_TAG_NAME, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/name")).put((Object)DriverCommand.IS_ELEMENT_SELECTED, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/selected")).put((Object)DriverCommand.SET_ELEMENT_SELECTED, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/selected")).put((Object)DriverCommand.TOGGLE_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/toggle")).put((Object)DriverCommand.IS_ELEMENT_ENABLED, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/enabled")).put((Object)DriverCommand.IS_ELEMENT_DISPLAYED, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/displayed")).put((Object)DriverCommand.HOVER_OVER_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/hover")).put((Object)DriverCommand.GET_ELEMENT_LOCATION, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/location")).put((Object)DriverCommand.GET_ELEMENT_SIZE, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/size")).put((Object)DriverCommand.GET_ELEMENT_ATTRIBUTE, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/attribute/:name")).put((Object)DriverCommand.ELEMENT_EQUALS, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/equals/:other")).put((Object)DriverCommand.GET_ALL_COOKIES, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/cookie")).put((Object)DriverCommand.ADD_COOKIE, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/cookie")).put((Object)DriverCommand.DELETE_ALL_COOKIES, (Object)HttpCommandExecutor.delete("/session/:sessionId/:context/cookie")).put((Object)DriverCommand.DELETE_COOKIE, (Object)HttpCommandExecutor.delete("/session/:sessionId/:context/cookie/:name")).put((Object)DriverCommand.SWITCH_TO_FRAME, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/frame/:id")).put((Object)DriverCommand.SWITCH_TO_WINDOW, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/window/:name")).put((Object)DriverCommand.CLOSE, (Object)HttpCommandExecutor.delete("/session/:sessionId/:context/window")).put((Object)DriverCommand.DRAG_ELEMENT, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/element/:id/drag")).put((Object)DriverCommand.GET_SPEED, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/speed")).put((Object)DriverCommand.SET_SPEED, (Object)HttpCommandExecutor.post("/session/:sessionId/:context/speed")).put((Object)DriverCommand.GET_ELEMENT_VALUE_OF_CSS_PROPERTY, (Object)HttpCommandExecutor.get("/session/:sessionId/:context/element/:id/css/:propertyName")).build();
    }

    public Response execute(Command command) throws Exception {
        CommandInfo info = this.nameToUrl.get(command.getName());
        HttpMethod httpMethod = info.getMethod(this.remotePath, command);
        httpMethod.addRequestHeader("Accept", "application/json, image/png");
        String payload = new BeanToJsonConverter().convert((Object)command.getParameters());
        if (httpMethod instanceof PostMethod) {
            ((PostMethod)httpMethod).setRequestEntity((RequestEntity)new StringRequestEntity(payload, "application/json", "UTF-8"));
        }
        this.client.executeMethod(httpMethod);
        if (this.isRedirect(httpMethod)) {
            Header newLocation = httpMethod.getResponseHeader("location");
            httpMethod = new GetMethod(newLocation.getValue());
            httpMethod.setFollowRedirects(true);
            httpMethod.addRequestHeader("Accept", "application/json, image/png");
            this.client.executeMethod(httpMethod);
        }
        return this.createResponse(httpMethod);
    }

    private Response createResponse(HttpMethod httpMethod) throws Exception {
        Response response;
        Header header = httpMethod.getResponseHeader("Content-Type");
        if (header != null && header.getValue().startsWith("application/json")) {
            response = (Response)new JsonToBeanConverter().convert(Response.class, (Object)httpMethod.getResponseBodyAsString());
        } else {
            int nextSlash;
            response = new Response();
            if (header != null && header.getValue().startsWith("image/png")) {
                response.setValue((Object)httpMethod.getResponseBody());
            } else {
                response.setValue((Object)httpMethod.getResponseBodyAsString());
            }
            String uri = httpMethod.getURI().toString();
            int sessionIndex = uri.indexOf("/session/");
            if (sessionIndex != -1 && (nextSlash = uri.indexOf("/", sessionIndex += "/session/".length())) != -1) {
                response.setSessionId(uri.substring(sessionIndex, nextSlash));
                response.setContext("foo");
            }
        }
        response.setError(httpMethod.getStatusCode() <= 199 || httpMethod.getStatusCode() >= 300);
        if (response.getValue() instanceof String) {
            response.setValue((Object)((String)response.getValue()).replace("\r\n", "\n"));
        }
        return response;
    }

    private boolean isRedirect(HttpMethod httpMethod) {
        int code = httpMethod.getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && httpMethod.getResponseHeader("location") != null;
    }

    private static CommandInfo get(String url) {
        return new CommandInfo(url, HttpVerb.GET);
    }

    private static CommandInfo post(String url) {
        return new CommandInfo(url, HttpVerb.POST);
    }

    private static CommandInfo delete(String url) {
        return new CommandInfo(url, HttpVerb.DELETE);
    }

    private static class CommandInfo {
        private final String url;
        private final HttpVerb verb;

        public CommandInfo(String url, HttpVerb verb) {
            this.url = url;
            this.verb = verb;
        }

        public HttpMethod getMethod(String base, Command command) {
            StringBuilder urlBuilder = new StringBuilder(base);
            for (String part : this.url.split("/")) {
                if (part.length() == 0) continue;
                urlBuilder.append("/");
                if (part.startsWith(":")) {
                    String value = this.get(part.substring(1), command);
                    if (value == null) continue;
                    urlBuilder.append(this.get(part.substring(1), command));
                    continue;
                }
                urlBuilder.append(part);
            }
            return this.verb.createMethod(urlBuilder.toString());
        }

        private String get(String propertyName, Command command) {
            if ("sessionId".equals(propertyName)) {
                return command.getSessionId().toString();
            }
            if ("context".equals(propertyName)) {
                return command.getContext().toString();
            }
            if (command.getParameters().length > 0 && command.getParameters()[0] instanceof Map) {
                Object value = ((Map)command.getParameters()[0]).get(propertyName);
                if (value != null) {
                    try {
                        return URLEncoder.encode(String.valueOf(value), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return String.valueOf(value);
                    }
                }
                return null;
            }
            throw new IllegalArgumentException("Cannot determine property: " + propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HttpVerb {
        GET{

            public HttpMethod createMethod(String url) {
                GetMethod getMethod = new GetMethod(url);
                getMethod.setFollowRedirects(true);
                return getMethod;
            }
        }
        ,
        POST{

            public HttpMethod createMethod(String url) {
                return new PostMethod(url);
            }
        }
        ,
        DELETE{

            public HttpMethod createMethod(String url) {
                return new DeleteMethod(url);
            }
        };


        public abstract HttpMethod createMethod(String var1);
    }
}

