/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.internal.OutputWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcess {
    private static final int THREADS_PER_SUBPROCESS = 3;
    private final ProcessBuilder processBuilder;
    private final OutputStream outputStream;
    private ExecutorService executorService;
    private Process currentProcess;
    private FutureTask<Integer> babySitter;
    private Future<?> outputWatcher;

    public SubProcess(ProcessBuilder processBuilder) {
        this(processBuilder, System.out);
    }

    public SubProcess(ProcessBuilder processBuilder, OutputStream outputStream) {
        this.processBuilder = processBuilder.redirectErrorStream(true);
        this.outputStream = outputStream;
        this.executorService = null;
        this.currentProcess = null;
        this.babySitter = null;
    }

    public void launch() {
        if (this.currentProcess == null) {
            try {
                this.currentProcess = this.processBuilder.start();
                this.babySitter = new FutureTask<Integer>(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return SubProcess.this.currentProcess.waitFor();
                    }
                });
                this.executorService = Executors.newFixedThreadPool(3);
                this.executorService.submit(this.babySitter);
                if (this.outputStream != null) {
                    this.outputWatcher = this.executorService.submit(new OutputWatcher(this.currentProcess.getInputStream(), this.outputStream));
                }
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    public State getState() {
        if (this.babySitter == null) {
            return State.NOT_RUNNING;
        }
        return this.babySitter.isDone() ? State.FINISHED : State.RUNNING;
    }

    public void shutdown() {
        this.babySitter = this.cancelFuture(this.babySitter);
        this.outputWatcher = this.cancelFuture(this.outputWatcher);
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
            this.currentProcess = null;
        }
    }

    private <T extends Future> T cancelFuture(T future) {
        if (future != null) {
            future.cancel(true);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED;

    }
}

