/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Context;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanToJsonConverter {
    private static final int MAX_DEPTH = 5;

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Object converted = this.convertObject(object, 5);
            if (converted instanceof JSONObject || converted instanceof JSONArray) {
                return converted.toString();
            }
            return String.valueOf(object);
        }
        catch (JSONException e) {
            throw new WebDriverException("Unable to convert: " + object, (Throwable)e);
        }
    }

    private Object convertUnknownObjectFromJson(Object o) {
        if (o instanceof JSONArray) {
            return this.convertJsonArray((JSONArray)o);
        }
        if (o instanceof JSONObject) {
            return this.convertJsonObject((JSONObject)o);
        }
        return o;
    }

    private Map<String, Object> convertJsonObject(JSONObject jsonObject) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        Iterator allKeys = jsonObject.keys();
        while (allKeys.hasNext()) {
            String key = (String)allKeys.next();
            try {
                toReturn.put(key, this.convertUnknownObjectFromJson(jsonObject.get(key)));
            }
            catch (JSONException e) {
                throw new IllegalStateException("Unable to access key: " + key, e);
            }
        }
        return toReturn;
    }

    private List<Object> convertJsonArray(JSONArray jsonArray) {
        ArrayList<Object> toReturn = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                toReturn.add(this.convertUnknownObjectFromJson(jsonArray.get(i)));
                continue;
            }
            catch (JSONException e) {
                throw new IllegalStateException("Cannot convert object at index: " + i, e);
            }
        }
        return toReturn;
    }

    private Object convertObject(Object toConvert, int maxDepth) throws JSONException {
        if (toConvert == null) {
            return null;
        }
        if (toConvert instanceof Boolean || toConvert instanceof CharSequence || toConvert instanceof Number) {
            return toConvert;
        }
        if (toConvert.getClass().isEnum() || toConvert instanceof Enum) {
            return toConvert.toString();
        }
        if (toConvert instanceof Map) {
            JSONObject converted = new JSONObject();
            Iterator i$ = ((Map)toConvert).entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry objectEntry;
                Map.Entry entry = objectEntry = i$.next();
                converted.put((String)entry.getKey(), this.convertObject(entry.getValue(), maxDepth - 1));
            }
            return converted;
        }
        if (toConvert instanceof JSONObject) {
            return toConvert;
        }
        if (toConvert instanceof Collection) {
            JSONArray array = new JSONArray();
            for (Object o : (Collection)toConvert) {
                array.put(this.convertObject(o, maxDepth - 1));
            }
            return array;
        }
        if (toConvert.getClass().isArray()) {
            JSONArray converted = new JSONArray();
            int length = Array.getLength(toConvert);
            for (int i = 0; i < length; ++i) {
                converted.put(this.convertObject(Array.get(toConvert, i), maxDepth - 1));
            }
            return converted;
        }
        if (toConvert instanceof Context) {
            JSONObject converted = new JSONObject();
            converted.put("value", (Object)toConvert.toString());
            return converted;
        }
        if (toConvert instanceof SessionId) {
            JSONObject converted = new JSONObject();
            converted.put("value", (Object)toConvert.toString());
            return converted;
        }
        try {
            return this.mapObject(toConvert, maxDepth - 1);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Object mapObject(Object toConvert, int maxDepth) throws Exception {
        if (maxDepth == 0) {
            return null;
        }
        JSONObject mapped = new JSONObject();
        BeanInfo beanInfo = Introspector.getBeanInfo(toConvert.getClass());
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if ("class".equals(pd.getName())) {
                mapped.put("class", (Object)toConvert.getClass().getName());
                continue;
            }
            Method readMethod = pd.getReadMethod();
            if (readMethod == null) continue;
            readMethod.setAccessible(true);
            Object result = readMethod.invoke(toConvert, new Object[0]);
            mapped.put(pd.getName(), this.convertObject(result, maxDepth - 1));
        }
        return mapped;
    }
}

