/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.Capabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesiredCapabilities
implements Capabilities {
    private String browserName;
    private String version;
    private Platform platform;
    private boolean javascriptEnabled;

    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.browserName = browser;
        this.version = version;
        this.platform = platform;
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, Object> rawMap) {
        this.browserName = (String)rawMap.get("browserName");
        this.version = (String)rawMap.get("version");
        this.javascriptEnabled = (Boolean)rawMap.get("javascriptEnabled");
        if (rawMap.containsKey("operatingSystem")) {
            Object os = rawMap.get("operatingSystem");
            if (os instanceof String) {
                this.platform = Platform.valueOf((String)((String)os));
            } else if (os instanceof Platform) {
                this.platform = (Platform)os;
            }
        }
        if (rawMap.containsKey("platform")) {
            Object raw = rawMap.get("platform");
            if (raw instanceof String) {
                this.platform = Platform.valueOf((String)((String)raw));
            } else if (raw instanceof Platform) {
                this.platform = (Platform)raw;
            }
        }
    }

    @Override
    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    @Override
    public boolean isJavascriptEnabled() {
        return this.javascriptEnabled;
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.javascriptEnabled = javascriptEnabled;
    }

    public static DesiredCapabilities firefox() {
        return new DesiredCapabilities("firefox", "", Platform.ANY);
    }

    public static DesiredCapabilities internetExplorer() {
        return new DesiredCapabilities("internet explorer", "", Platform.WINDOWS);
    }

    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities("htmlunit", "", Platform.ANY);
    }

    public static DesiredCapabilities iphone() {
        return new DesiredCapabilities("iphone", "", Platform.MAC);
    }

    public static DesiredCapabilities chrome() {
        return new DesiredCapabilities("chrome", "", Platform.ANY);
    }

    public String toString() {
        return String.format("Capabilities [browserName=%s, javascriptEnabled=%s, platform=%s, version=%s]", this.browserName, this.javascriptEnabled, this.platform, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesiredCapabilities)) {
            return false;
        }
        DesiredCapabilities that = (DesiredCapabilities)o;
        if (this.javascriptEnabled != that.javascriptEnabled) {
            return false;
        }
        if (this.browserName != null ? !this.browserName.equals(that.browserName) : that.browserName != null) {
            return false;
        }
        if (!this.platform.is(that.platform)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.browserName != null ? this.browserName.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
        result = 31 * result + (this.javascriptEnabled ? 1 : 0);
        return result;
    }
}

