/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.WindowClosedException;
import org.openqa.selenium.server.log.LoggingManager;
import org.openqa.selenium.server.log.StdOutHandler;
import org.openqa.selenium.server.log.TerseFormatter;
import org.openqa.selenium.testworker.TrackableRunnable;
import org.openqa.selenium.testworker.TrackableThread;

public class CommandQueueUnitTest
extends TestCase {
    private static final String sessionId = "1";
    private static final String testCommand = "testCommand";
    private static final String waitCommand = "waitForSomethingCommand";
    private static final String testResult = "OK";
    private static final int defaultTimeout = 7;
    private static final int retryTimeout = 5;
    private static Log log = LogFactory.getLog(CommandQueueUnitTest.class);
    private CommandQueue cq;
    private RemoteControlConfiguration configuration;

    public void setUp() throws Exception {
        this.configureLogging();
        this.configuration = new RemoteControlConfiguration();
        this.configuration.setTimeoutInSeconds(7);
        this.configuration.setProxyInjectionModeArg(false);
        this.cq = new CommandQueue(sessionId, this.getName(), this.configuration);
        log.info((Object)("Start test: " + this.getName()));
    }

    private void configureLogging() throws Exception {
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)true);
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof StdOutHandler)) continue;
            handler.setFormatter((Formatter)new TerseFormatter(true));
            break;
        }
    }

    public void tearDown() throws Exception {
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)false);
    }

    public void testQueueDelayInitializedAtDefault() {
        CommandQueueUnitTest.assertEquals((int)CommandQueue.getSpeed(), (int)this.cq.getQueueDelay());
    }

    public void testQueueDelayChangedAsSetNoCrosstalk() {
        int defaultSpeed = CommandQueue.getSpeed();
        int newSpeed = this.cq.getQueueDelay() + 42;
        int newGlobalSpeed = defaultSpeed + 21;
        this.cq.setQueueDelay(newSpeed);
        CommandQueue.setSpeed((int)newGlobalSpeed);
        CommandQueueUnitTest.assertEquals((int)newSpeed, (int)this.cq.getQueueDelay());
        CommandQueueUnitTest.assertEquals((int)newGlobalSpeed, (int)CommandQueue.getSpeed());
        CommandQueue cq2 = new CommandQueue(sessionId, this.getName() + "2", new RemoteControlConfiguration());
        CommandQueueUnitTest.assertEquals((int)newGlobalSpeed, (int)cq2.getQueueDelay());
        CommandQueue cq3 = new CommandQueue(sessionId, this.getName() + "3", newSpeed, new RemoteControlConfiguration());
        CommandQueueUnitTest.assertEquals((int)newSpeed, (int)cq3.getQueueDelay());
        CommandQueue.setSpeed((int)defaultSpeed);
    }

    public void testAssertStartingState() {
        CommandQueueUnitTest.assertNull((Object)this.cq.peekAtCommand());
        CommandQueueUnitTest.assertNull((Object)this.cq.peekAtResult());
    }

    public void testBasicDoCommandWithoutWaiting() throws WindowClosedException {
        this.cq.doCommandWithoutWaitingForAResponse(testCommand, "", "");
        RemoteCommand rc = this.cq.peekAtCommand();
        CommandQueueUnitTest.assertNotNull((Object)rc);
        CommandQueueUnitTest.assertEquals((String)testCommand, (String)rc.getCommand());
        CommandQueueUnitTest.assertNull((Object)this.cq.peekAtResult());
    }

    public void testDoCommandWithoutWaitingWithResultAlreadyThereWithNoPI() throws WindowClosedException {
        this.cq.putResult(testResult);
        try {
            this.cq.doCommandWithoutWaitingForAResponse(testCommand, "", "");
            CommandQueueUnitTest.fail();
        }
        catch (IllegalStateException ise) {
            CommandQueueUnitTest.assertNotNull((Object)this.cq.peekAtResult());
        }
    }

    public void testDoCommandWithoutWaitingWithResultAlreadyThereWithPI() throws WindowClosedException {
        this.configuration = new RemoteControlConfiguration();
        this.configuration.setTimeoutInSeconds(7);
        this.configuration.setProxyInjectionModeArg(true);
        this.cq = new CommandQueue(sessionId, this.getName(), this.configuration);
        this.cq.putResult(testResult);
        this.cq.doCommandWithoutWaitingForAResponse(testCommand, "", "");
        CommandQueueUnitTest.assertEquals((String)testResult, (String)this.cq.peekAtResult());
    }

    public void testDoCommandWithoutWaitingWithBadResultAlreadyThereWithPI() throws WindowClosedException {
        this.configuration = new RemoteControlConfiguration();
        this.configuration.setTimeoutInSeconds(7);
        this.configuration.setProxyInjectionModeArg(true);
        this.cq = new CommandQueue(sessionId, this.getName(), this.configuration);
        this.cq.putResult(testResult);
        this.cq.doCommandWithoutWaitingForAResponse(waitCommand, "", "");
        CommandQueueUnitTest.assertEquals((String)testResult, (String)this.cq.peekAtResult());
    }

    public void testGetsTimeoutExceptionOnGetResult() {
        this.expectResult("ERROR: Command timed out");
        CommandQueueUnitTest.assertNull((Object)this.cq.peekAtResult());
    }

    public void testDoCommandTimesOut() {
        long now = System.currentTimeMillis();
        String result = this.cq.doCommand(testCommand, "", "");
        long after = System.currentTimeMillis();
        CommandQueueUnitTest.assertEquals((String)"ERROR: Command timed out", (String)result);
        CommandQueueUnitTest.assertTrue((after - now > 7L ? 1 : 0) != 0);
    }

    public void testGetsPrevCommandFromHandleNullResult() throws WindowClosedException {
        this.cq.doCommandWithoutWaitingForAResponse(testCommand, "", "");
        RemoteCommand rc = this.cq.handleCommandResult(null);
        CommandQueueUnitTest.assertEquals((String)testCommand, (String)rc.getCommand());
    }

    public void testSendsRetryCommandIfNoneAfterRetryPeriod() {
        long now = System.currentTimeMillis();
        RemoteCommand rc = this.cq.handleCommandResult(null);
        long after = System.currentTimeMillis();
        CommandQueueUnitTest.assertTrue((after - now > 5L ? 1 : 0) != 0);
        CommandQueueUnitTest.assertEquals((String)"retryLast", (String)rc.getCommand());
    }

    public void testHandleResultNoWaitingWithOKResultWithResExpectedNoPI() {
        this.cq.setResultExpected(true);
        this.cq.handleCommandResultWithoutWaitingForACommand(testResult);
        CommandQueueUnitTest.assertEquals((String)testResult, (String)this.cq.peekAtResult());
    }

    public void testHandleResultWithOKResultWithNoResExpectedWithPI() {
        this.configuration = new RemoteControlConfiguration();
        this.configuration.setTimeoutInSeconds(7);
        this.configuration.setProxyInjectionModeArg(true);
        this.cq = new CommandQueue(sessionId, this.getName(), this.configuration);
        this.cq.handleCommandResultWithoutWaitingForACommand(testResult);
        CommandQueueUnitTest.assertEquals((String)testResult, (String)this.cq.peekAtResult());
    }

    public void testGetNextCommandWhenAlreadyWaiting() throws Throwable {
        this.cq.setResultExpected(true);
        TrackableRunnable internalRunner = new TrackableRunnable(){

            public Object go() throws Throwable {
                CommandQueueUnitTest.this.cq.doCommandWithoutWaitingForAResponse(CommandQueueUnitTest.testCommand, "", "");
                return null;
            }
        };
        String name = "launching runner";
        TrackableThread t = new TrackableThread(internalRunner, name);
        t.start();
        t.getResult();
        this.assertsForCommandState(this.cq.getNextCommand());
    }

    private void assertsForCommandState(RemoteCommand cmd) {
        CommandQueueUnitTest.assertNotNull((Object)cmd);
        CommandQueueUnitTest.assertEquals((String)testCommand, (String)cmd.getCommand());
    }

    public void testSimpleSingleThreaded() throws Exception {
        this.injectCommandAsIfWaiting("something", "arg1", "arg2");
        this.expectCommand("something", "arg1", "arg2");
        this.cq.handleCommandResultWithoutWaitingForACommand(testResult);
        this.expectResult(testResult);
    }

    public void testRealSimple() throws Throwable {
        TrackableThread commandRunner = this.launchCommandRunner("something", "arg1", "arg2");
        this.expectCommand("something", "arg1", "arg2");
        this.cq.handleCommandResultWithoutWaitingForACommand(testResult);
        CommandQueueUnitTest.assertEquals((Object)testResult, (Object)commandRunner.getResult());
    }

    public void testTwoRoundsSingleThreaded() throws Exception {
        this.testSimpleSingleThreaded();
        this.cq.doCommandWithoutWaitingForAResponse("testComplete", "", "");
        this.expectCommand("testComplete", "", "");
        this.cq.handleCommandResultWithoutWaitingForACommand(testResult);
        this.expectResult(testResult);
    }

    public void testRealTwoRounds() throws Throwable {
        TrackableThread commandRunner = this.launchCommandRunner("something", "arg1", "arg2");
        TrackableThread browserRequestRunner = this.launchBrowserResultRunner(null);
        this.expectCommand(browserRequestRunner, "something", "arg1", "arg2");
        browserRequestRunner = this.launchBrowserResultRunner(testResult);
        CommandQueueUnitTest.assertEquals((Object)testResult, (Object)commandRunner.getResult());
        this.cq.doCommandWithoutWaitingForAResponse("testComplete", "", "");
        this.expectCommand(browserRequestRunner, "testComplete", "", "");
    }

    public void testPIOpenSingleThreaded() throws Exception {
        this.injectCommandAsIfWaiting("open", "blah.html", "");
        this.expectCommand("open", "blah.html", "");
        this.cq.handleCommandResultWithoutWaitingForACommand(testResult);
        this.cq.declareClosed();
        CommandQueueUnitTest.assertEquals((String)testResult, (String)this.cq.peekAtResult());
    }

    private void injectCommandAsIfWaiting(String cmd, String field, String value) throws WindowClosedException {
        this.cq.setResultExpected(true);
        this.cq.doCommandWithoutWaitingForAResponse(cmd, field, value);
    }

    private void expectCommand(TrackableThread browserRequestRunner, String cmd, String arg1, String arg2) throws Throwable {
        RemoteCommand actual = (RemoteCommand)browserRequestRunner.getResult();
        DefaultRemoteCommand expected = new DefaultRemoteCommand(cmd, arg1, arg2);
        CommandQueueUnitTest.assertEquals((String)(cmd + " command got mangled"), (Object)expected, (Object)actual);
    }

    private void expectCommand(String cmd, String arg1, String arg2) {
        RemoteCommand actual = this.cq.getNextCommand();
        DefaultRemoteCommand expected = new DefaultRemoteCommand(cmd, arg1, arg2);
        CommandQueueUnitTest.assertEquals((String)(cmd + " command got mangled"), (Object)expected, (Object)actual);
    }

    private void expectResult(String expected) {
        String actual = this.cq.getResult();
        CommandQueueUnitTest.assertEquals((String)(expected + " result got mangled"), (String)expected, (String)actual);
    }

    private TrackableThread launchCommandRunner(String cmd, String arg1, String arg2) {
        TrackableThread t = new TrackableThread(new AsyncCommandRunner(cmd, arg1, arg2), cmd);
        t.start();
        return t;
    }

    private TrackableThread launchBrowserResultRunner(String browserResult) {
        String name = browserResult;
        if (name == null) {
            name = "NULL STARTING";
        }
        TrackableThread t = new TrackableThread(new AsyncBrowserResultRunner(browserResult), name);
        t.start();
        return t;
    }

    private class AsyncBrowserResultRunner
    extends TrackableRunnable {
        private String browserResult;

        public AsyncBrowserResultRunner(String browserResult) {
            this.browserResult = browserResult;
        }

        public Object go() throws Throwable {
            RemoteCommand result = CommandQueueUnitTest.this.cq.handleCommandResult(this.browserResult);
            log.info((Object)(Thread.currentThread().getName() + " got result: " + result));
            return result;
        }
    }

    private class AsyncCommandRunner
    extends TrackableRunnable {
        private String cmd;
        private String arg1;
        private String arg2;

        public AsyncCommandRunner(String cmd, String arg1, String arg2) {
            this.cmd = cmd;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public Object go() throws Throwable {
            String result = CommandQueueUnitTest.this.cq.doCommand(this.cmd, this.arg1, this.arg2);
            log.info((Object)(Thread.currentThread().getName() + " got result: " + result));
            return result;
        }
    }
}

