/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import junit.framework.TestCase;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;

public class DefaultRemoteCommandUnitTest
extends TestCase {
    public DefaultRemoteCommandUnitTest(String name) {
        super(name);
    }

    public void testParseNoJs() {
        DefaultRemoteCommand drc = new DefaultRemoteCommand("foo", "bar", "baz");
        RemoteCommand parsed = DefaultRemoteCommand.parse((String)drc.toString());
        DefaultRemoteCommandUnitTest.assertEquals((Object)drc, (Object)parsed);
    }

    public void testParsePiggyBackedJs() {
        DefaultRemoteCommand drc = new DefaultRemoteCommand("foo", "bar", "baz", "2+2");
        RemoteCommand parsed = DefaultRemoteCommand.parse((String)drc.toString());
        DefaultRemoteCommandUnitTest.assertEquals((Object)drc, (Object)parsed);
    }

    public void testEvil() {
        DefaultRemoteCommand drc = new DefaultRemoteCommand("\\\"'\b\n\r\f\t\u2000", "bar", "baz");
        RemoteCommand parsed = DefaultRemoteCommand.parse((String)drc.toString());
        DefaultRemoteCommandUnitTest.assertEquals((Object)drc, (Object)parsed);
    }

    public void testUnicode() {
        RemoteCommand parsed = DefaultRemoteCommand.parse((String)"json={command:\"\\u2000\",target:\"bar\",value:\"baz\"}");
        DefaultRemoteCommand drc = new DefaultRemoteCommand("\u2000", "bar", "baz");
        DefaultRemoteCommandUnitTest.assertEquals((Object)drc, (Object)parsed);
    }

    public void testBlankStringNoJs() {
        DefaultRemoteCommand drc = new DefaultRemoteCommand("", "", "");
        RemoteCommand parsed = DefaultRemoteCommand.parse((String)drc.toString());
        DefaultRemoteCommandUnitTest.assertEquals((Object)drc, (Object)parsed);
    }

    public void testBlankStringPiggyBackedJs() {
        DefaultRemoteCommand drc = new DefaultRemoteCommand("", "", "", "");
        RemoteCommand parsed = DefaultRemoteCommand.parse((String)drc.toString());
        DefaultRemoteCommandUnitTest.assertEquals((Object)drc, (Object)parsed);
    }

    public void testEqualReturnsFalseWhenComparedWithNull() {
        DefaultRemoteCommandUnitTest.assertFalse((boolean)new DefaultRemoteCommand("", "", "").equals(null));
    }

    public void testEqualReturnsFalseWhenCommandsDoNotMatch() {
        DefaultRemoteCommandUnitTest.assertFalse((boolean)new DefaultRemoteCommand("a command", "", "").equals((Object)new DefaultRemoteCommand("another command", "", "")));
    }

    public void testEqualReturnsFalseWhenFieldsDoNotMatch() {
        DefaultRemoteCommandUnitTest.assertFalse((boolean)new DefaultRemoteCommand("", "a field", "").equals((Object)new DefaultRemoteCommand("", "another field", "")));
    }

    public void testEqualReturnsFalseWhenValuesDoNotMatch() {
        DefaultRemoteCommandUnitTest.assertFalse((boolean)new DefaultRemoteCommand("", "", "a value").equals((Object)new DefaultRemoteCommand("", "", "another value")));
    }

    public void testEqualReturnsTrueWhenCommandsFieldsAndValuesDoMatch() {
        DefaultRemoteCommandUnitTest.assertEquals((Object)new DefaultRemoteCommand("a command", "a field", "a value"), (Object)new DefaultRemoteCommand("a command", "a field", "a value"));
    }

    public void testHascodeIsDifferentWhenCommandsDoNotMatch() {
        DefaultRemoteCommandUnitTest.assertNotSame((Object)new DefaultRemoteCommand("a command", "", "").hashCode(), (Object)new DefaultRemoteCommand("another command", "", "").hashCode());
    }

    public void testHascodeIsDifferentWhenFieldsDoNotMatch() {
        DefaultRemoteCommandUnitTest.assertNotSame((Object)new DefaultRemoteCommand("", "a field", "").hashCode(), (Object)new DefaultRemoteCommand("", "another field", "").hashCode());
    }

    public void testHascodeIsDifferentWhenValuesDoNotMatch() {
        DefaultRemoteCommandUnitTest.assertNotSame((Object)new DefaultRemoteCommand("", "", "a value").hashCode(), (Object)new DefaultRemoteCommand("", "", "another value").hashCode());
    }

    public void testHascodeIsIdenticalWhenCommandsFieldsAndValuesDoMatch() {
        DefaultRemoteCommandUnitTest.assertEquals((int)new DefaultRemoteCommand("a command", "a field", "a value").hashCode(), (int)new DefaultRemoteCommand("a command", "a field", "a value").hashCode());
    }
}

