/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.easymock.classextension.EasyMock;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.openqa.selenium.server.ProxyHandler;

public class ProxyHanderUnitTest
extends TestCase {
    public void testSendNotFoundSends404ResponseCode() throws Exception {
        ProxyHandler proxyHandler = new ProxyHandler(true, "", "", false, false);
        HttpResponse httpResponseMock = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        httpResponseMock.sendError(404, "Not found");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{httpResponseMock});
        proxyHandler.sendNotFound(httpResponseMock);
        EasyMock.verify((Object[])new Object[]{httpResponseMock});
    }

    public void testHandleCallsSendNotFoundWhenAskingForNonExistentResource() throws Exception {
        ProxyHandler proxyHandlerMock = (ProxyHandler)EasyMock.createMock(ProxyHandler.class, (Method[])new Method[]{ProxyHandler.class.getDeclaredMethod("sendNotFound", HttpResponse.class)});
        String pathInContext = "/invalid";
        String pathParams = "";
        HttpRequest httpRequest = new HttpRequest();
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setAttribute("NotFound", (Object)"True");
        proxyHandlerMock.sendNotFound(httpResponse);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{proxyHandlerMock});
        proxyHandlerMock.handle(pathInContext, pathParams, httpRequest, httpResponse);
        ProxyHanderUnitTest.assertNull((Object)httpResponse.getAttribute("NotFound"));
        EasyMock.verify((Object[])new Object[]{proxyHandlerMock});
    }
}

