/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;

public class RemoteControlConfigurationUnitTest {
    private final RemoteControlConfiguration configuration = new RemoteControlConfiguration();

    @Before
    public void setUp() {
    }

    @Test
    public void testPortIs4444ByDefault() {
        Assert.assertEquals((long)4444L, (long)this.configuration.getPort());
    }

    @Test
    public void testPortCanBeSet() {
        this.configuration.setPort(1234);
        Assert.assertEquals((long)1234L, (long)this.configuration.getPort());
    }

    @Test
    public void testMultiWindowIsTrueByDefault() {
        Assert.assertTrue((!this.configuration.isSingleWindow() ? 1 : 0) != 0);
    }

    @Test
    public void testMultiWindowCanBeSet() {
        this.configuration.setSingleWindow(false);
        Assert.assertTrue((!this.configuration.isSingleWindow() ? 1 : 0) != 0);
    }

    @Test
    public void testProxyInjectionModeArgIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.getProxyInjectionModeArg());
    }

    @Test
    public void testProxyInjectionModeArgCanBeSet() {
        this.configuration.setProxyInjectionModeArg(true);
        Assert.assertTrue((boolean)this.configuration.getProxyInjectionModeArg());
    }

    @Test
    public void testPortDriversShouldContactIsSamePortByDefault() {
        this.configuration.setPort(1515);
        Assert.assertEquals((long)1515L, (long)this.configuration.getPortDriversShouldContact());
    }

    @Test
    public void testPortDriversShouldContactCanBeSet() {
        this.configuration.setPortDriversShouldContact(1234);
        Assert.assertEquals((long)1234L, (long)this.configuration.getPortDriversShouldContact());
    }

    @Test
    public void testHTMLSuiteIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.isHTMLSuite());
    }

    @Test
    public void testHTMLSuiteCanBeSet() {
        this.configuration.setHTMLSuite(true);
        Assert.assertTrue((boolean)this.configuration.isHTMLSuite());
    }

    @Test
    public void testSelfTestIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.isSelfTest());
    }

    @Test
    public void testSelfTestCanBeSet() {
        this.configuration.setSelfTest(true);
        Assert.assertTrue((boolean)this.configuration.isSelfTest());
    }

    @Test
    public void testSelfTestDirIsNullByDefault() {
        Assert.assertNull((Object)this.configuration.getSelfTestDir());
    }

    @Test
    public void testSelfTestDirCanBeSet() {
        File aDirectory = new File("\"A Directory Name\"");
        this.configuration.setSelfTestDir(aDirectory);
        Assert.assertEquals((Object)aDirectory, (Object)this.configuration.getSelfTestDir());
    }

    @Test
    public void testInteractiveIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.isInteractive());
    }

    @Test
    public void testInteractiveCanBeSet() {
        this.configuration.setInteractive(true);
        Assert.assertTrue((boolean)this.configuration.isInteractive());
    }

    @Test
    public void testUserExtensionsIsNullByDefault() {
        Assert.assertNull((Object)this.configuration.getUserExtensions());
    }

    @Test
    public void testUserExtensionsCanBeSet() {
        File aDirectory = new File("\"A File Name\"");
        this.configuration.setUserExtensions(aDirectory);
        Assert.assertEquals((Object)aDirectory, (Object)this.configuration.getUserExtensions());
    }

    @Test
    public void testUserJSInjectionIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.userJSInjection());
    }

    @Test
    public void testUserJSInjectionCanBeSet() {
        this.configuration.setUserJSInjection(true);
        Assert.assertTrue((boolean)this.configuration.userJSInjection());
    }

    @Test
    public void testTrustAllSSLCertificatesIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.trustAllSSLCertificates());
    }

    @Test
    public void testTrustAllSSLCertificatesCanBeSet() {
        this.configuration.setTrustAllSSLCertificates(true);
        Assert.assertTrue((boolean)this.configuration.trustAllSSLCertificates());
    }

    @Test
    public void testDebugURLIsEmptyByDefault() {
        Assert.assertEquals((Object)"", (Object)this.configuration.getDebugURL());
    }

    @Test
    public void testDebugURLCanBeSet() {
        this.configuration.setDebugURL("A URL");
        Assert.assertEquals((Object)"A URL", (Object)this.configuration.getDebugURL());
    }

    @Test
    public void testDontInjectRegexIsNullByDefault() {
        Assert.assertNull((Object)this.configuration.getDontInjectRegex());
    }

    @Test
    public void testDontInjectRegexCanBeSet() {
        this.configuration.setDontInjectRegex("A Regex");
        Assert.assertEquals((Object)"A Regex", (Object)this.configuration.getDontInjectRegex());
    }

    @Test
    public void testFirefoxProfileTemplateIsNullByDefault() {
        Assert.assertNull((Object)this.configuration.getFirefoxProfileTemplate());
    }

    @Test
    public void testFirefoxProfileTemplateCanBeSet() {
        File aDirectory = new File("\"A Directory Path\"");
        this.configuration.setFirefoxProfileTemplate(aDirectory);
        Assert.assertEquals((Object)aDirectory, (Object)this.configuration.getFirefoxProfileTemplate());
    }

    @Test
    public void testReuseBrowserSessionsIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.reuseBrowserSessions());
    }

    @Test
    public void testReuseBrowserSessionsCanBeSet() {
        this.configuration.setReuseBrowserSessions(true);
        Assert.assertTrue((boolean)this.configuration.reuseBrowserSessions());
    }

    @Test
    public void testLogoutFileNameIsNullByDefault() {
        Assert.assertNull((Object)this.configuration.getLogOutFileName());
    }

    @Test
    public void testLogoutFileNameCanBeSet() {
        this.configuration.setLogOutFileName("A File Name");
        Assert.assertEquals((Object)"A File Name", (Object)this.configuration.getLogOutFileName());
    }

    @Test
    public void testForcedBrowserModeIsNullByDefault() {
        Assert.assertNull((Object)this.configuration.getForcedBrowserMode());
    }

    @Test
    public void testForcedBrowserModeCanBeSet() {
        this.configuration.setForcedBrowserMode("A Mode");
        Assert.assertEquals((Object)"A Mode", (Object)this.configuration.getForcedBrowserMode());
    }

    @Test
    public void testHonorSystemProxyIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.honorSystemProxy());
    }

    @Test
    public void testHonorSystemProxyCanBeSet() {
        this.configuration.setHonorSystemProxy(true);
        Assert.assertTrue((boolean)this.configuration.honorSystemProxy());
    }

    @Test
    public void testShouldOverrideSystemProxyIsTrueByDefault() {
        Assert.assertTrue((boolean)this.configuration.shouldOverrideSystemProxy());
    }

    @Test
    public void testShouldOverrideSystemProxyIsFalseIfHonorSystemProxyIsSet() {
        this.configuration.setHonorSystemProxy(true);
        Assert.assertFalse((boolean)this.configuration.shouldOverrideSystemProxy());
    }

    @Test
    public void testTimeoutInSecondsIs30MinutesByDefault() {
        Assert.assertEquals((long)1800L, (long)this.configuration.getTimeoutInSeconds());
    }

    @Test
    public void testTimeoutInSecondsCanBeSet() {
        this.configuration.setTimeoutInSeconds(123);
        Assert.assertEquals((long)123L, (long)this.configuration.getTimeoutInSeconds());
    }

    @Test
    public void testRetryTimeoutInSecondsIs10SecondsByDefault() {
        Assert.assertEquals((long)10L, (long)this.configuration.getRetryTimeoutInSeconds());
    }

    @Test
    public void testRetryTimeoutInSecondsCanBeSet() {
        this.configuration.setRetryTimeoutInSeconds(123);
        Assert.assertEquals((long)123L, (long)this.configuration.getRetryTimeoutInSeconds());
    }

    @Test
    public void testDontTouchLoggingIsFalseByDefault() {
        Assert.assertFalse((boolean)this.configuration.dontTouchLogging());
    }

    @Test
    public void testDontTouchLoggingCanBeSet() {
        this.configuration.setDontTouchLogging(true);
        Assert.assertTrue((boolean)this.configuration.dontTouchLogging());
    }

    @Test
    public void testShortTermMemoryLoggerCapacityIs50Bydefault() {
        Assert.assertEquals((long)30L, (long)this.configuration.shortTermMemoryLoggerCapacity());
    }

    @Test
    public void remoteControlConfigurationWillBeCopiedIntoBrowserOptions() throws Exception {
        BrowserConfigurationOptions browserOptions = new BrowserConfigurationOptions();
        String fileName = "file";
        int timeOut = 5;
        boolean honorSystemProxy = true;
        String dontInjectRegex = "newdontInjectRegex";
        boolean trustAllSSLCertificates = true;
        File newuserExtensions = new File("newuserExtensions");
        boolean useUserJSInjection = true;
        boolean useProxyInjectionMode = true;
        boolean useSingleWindow = true;
        boolean ensureCleanSession = true;
        boolean avoidProxy = true;
        boolean browserSideLogEnabled = true;
        this.configuration.setFirefoxProfileTemplate(new File(fileName));
        this.configuration.setTimeoutInSeconds(timeOut);
        this.configuration.setHonorSystemProxy(honorSystemProxy);
        this.configuration.setDontInjectRegex(dontInjectRegex);
        this.configuration.setTrustAllSSLCertificates(trustAllSSLCertificates);
        this.configuration.setUserExtensions(newuserExtensions);
        this.configuration.setUserJSInjection(useUserJSInjection);
        this.configuration.setProxyInjectionModeArg(useProxyInjectionMode);
        this.configuration.setSingleWindow(useSingleWindow);
        this.configuration.setEnsureCleanSession(ensureCleanSession);
        this.configuration.setAvoidProxy(avoidProxy);
        this.configuration.setBrowserSideLogEnabled(browserSideLogEnabled);
        this.configuration.copySettingsIntoBrowserOptions(browserOptions);
        Assert.assertEquals((Object)fileName, (Object)browserOptions.get("firefoxProfileTemplate"));
        Assert.assertEquals((Object)Integer.toString(timeOut), (Object)browserOptions.get("timeoutInSeconds"));
        Assert.assertEquals((Object)Boolean.toString(honorSystemProxy), (Object)browserOptions.get("honorSystemProxy"));
        Assert.assertEquals((Object)dontInjectRegex, (Object)browserOptions.get("dontInjectRegex"));
        Assert.assertEquals((Object)Boolean.toString(trustAllSSLCertificates), (Object)browserOptions.get("trustAllSSLCertificates"));
        Assert.assertEquals((Object)newuserExtensions.getName(), (Object)browserOptions.get("userExtensions"));
        Assert.assertEquals((Object)Boolean.toString(useUserJSInjection), (Object)browserOptions.get("userJSInjection"));
        Assert.assertEquals((Object)Boolean.toString(useProxyInjectionMode), (Object)browserOptions.get("proxyInjectionMode"));
        Assert.assertEquals((Object)Boolean.toString(useSingleWindow), (Object)browserOptions.get("singleWindow"));
        Assert.assertEquals((Object)Boolean.toString(ensureCleanSession), (Object)browserOptions.get("ensureCleanSession"));
        Assert.assertEquals((Object)Boolean.toString(avoidProxy), (Object)browserOptions.get("avoidProxy"));
        Assert.assertEquals((Object)Boolean.toString(browserSideLogEnabled), (Object)browserOptions.get("browserSideLog"));
    }
}

