/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;

public class FirefoxCustomProfileLauncherUnitTest
extends TestCase {
    public void testProfileRemovedWhenProcessNull() {
        FirefoxCustomProfileLauncherStubbedForShutdown launcher = new FirefoxCustomProfileLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.close();
        FirefoxCustomProfileLauncherUnitTest.assertFalse((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxCustomProfileLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testProfileRemovedWhenProcessKillFails() {
        FirefoxCustomProfileLauncherStubbedForShutdown launcher = new FirefoxCustomProfileLauncherStubbedForShutdown();
        launcher.haveProcessKillThrowException(false);
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.setProcess(new TestProcess());
        launcher.close();
        FirefoxCustomProfileLauncherUnitTest.assertTrue((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxCustomProfileLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testProfileRemovedWhenProcessNotNull() {
        FirefoxCustomProfileLauncherStubbedForShutdown launcher = new FirefoxCustomProfileLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.setProcess(new TestProcess());
        launcher.close();
        FirefoxCustomProfileLauncherUnitTest.assertTrue((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxCustomProfileLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testNothingRemovedIfAlreadyNull() {
        FirefoxCustomProfileLauncherStubbedForShutdown launcher = new FirefoxCustomProfileLauncherStubbedForShutdown();
        launcher.close();
        FirefoxCustomProfileLauncherUnitTest.assertFalse((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxCustomProfileLauncherUnitTest.assertFalse((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testSecondCloseIsNoOp() {
        FirefoxCustomProfileLauncherStubbedForShutdown launcher = new FirefoxCustomProfileLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.close();
        FirefoxCustomProfileLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
        launcher.reset();
        launcher.close();
        FirefoxCustomProfileLauncherUnitTest.assertFalse((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public static class TestProcess
    extends Process {
        public void destroy() {
        }

        public int exitValue() {
            return 0;
        }

        public InputStream getErrorStream() {
            return null;
        }

        public InputStream getInputStream() {
            return null;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public int waitFor() throws InterruptedException {
            return 0;
        }
    }

    public static class FirefoxCustomProfileLauncherStubbedForShutdown
    extends FirefoxCustomProfileLauncher {
        private boolean killFirefoxProcessCalled = false;
        private boolean removeCustomProfileDirCalled = false;
        private boolean throwProcessKillException = true;

        public FirefoxCustomProfileLauncherStubbedForShutdown() {
            super(new BrowserConfigurationOptions(), new RemoteControlConfiguration(), "testsession", (String)null);
        }

        public void haveProcessKillThrowException(boolean doThrow) {
            this.throwProcessKillException = doThrow;
        }

        public void reset() {
            this.killFirefoxProcessCalled = false;
            this.removeCustomProfileDirCalled = false;
            this.throwProcessKillException = true;
        }

        public boolean wasKillFirefoxProcessCalled() {
            return this.killFirefoxProcessCalled;
        }

        public boolean wasRemoveCustomProfileCalled() {
            return this.removeCustomProfileDirCalled;
        }

        protected void killFirefoxProcess() throws FirefoxCustomProfileLauncher.FileLockRemainedException {
            this.killFirefoxProcessCalled = true;
            if (!this.throwProcessKillException) {
                throw new FirefoxCustomProfileLauncher.FileLockRemainedException((FirefoxCustomProfileLauncher)this, "test exception");
            }
        }

        protected void removeCustomProfileDir() throws RuntimeException {
            this.removeCustomProfileDirCalled = true;
        }
    }
}

