/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.easymock.classextension.EasyMock;
import org.junit.Test;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

public class SafariCustomProfileLauncherUnitTest {
    private AbstractBrowserLauncher launcher;
    private BrowserConfigurationOptions browserOptions = new BrowserConfigurationOptions();
    private RemoteControlConfiguration remoteConfiguration = new RemoteControlConfiguration();
    private SeleniumServer server;

    @Test(expected=InvalidBrowserExecutableException.class)
    public void constructor_invalidBrowserInstallationCausesException() throws Exception {
        this.launcher = new SafariCustomProfileLauncher(this.browserOptions, this.remoteConfiguration, "session", "invalid");
    }

    @Test
    public void launchRemoteSession_generatesSslCertsIfBrowserSideLogEnabled() throws Exception {
        String location = null;
        this.server = (SeleniumServer)EasyMock.createStrictMock(SeleniumServer.class);
        this.server.generateSSLCertsForLoggingHosts();
        EasyMock.expectLastCall().once();
        this.remoteConfiguration.setSeleniumServer(this.server);
        this.browserOptions.set("browserSideLog", (Object)true);
        this.launcher = new SafariCustomProfileLauncher(this.browserOptions, this.remoteConfiguration, "session", location){

            protected void launch(String url) {
            }

            protected BrowserInstallation locateSafari(String location) {
                return new BrowserInstallation("", "");
            }
        };
        EasyMock.replay((Object[])new Object[]{this.server});
        this.launcher.launchRemoteSession("http://url");
        EasyMock.verify((Object[])new Object[]{this.server});
    }
}

