/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.easymock.classextension.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class HtmlLauncherUnitTest {
    private SeleniumServer remoteControl;
    private RemoteControlConfiguration configuration;
    private File outputFile;
    private HTMLTestResults results;
    private HTMLLauncher launcher;

    @Before
    public void setUp() throws Exception {
        this.remoteControl = (SeleniumServer)EasyMock.createNiceMock(SeleniumServer.class);
        this.configuration = (RemoteControlConfiguration)EasyMock.createNiceMock(RemoteControlConfiguration.class);
        this.results = (HTMLTestResults)EasyMock.createNiceMock(HTMLTestResults.class);
        this.launcher = new HTMLLauncher(this.remoteControl){
            final BrowserLauncher browserLauncher;
            {
                this.browserLauncher = (BrowserLauncher)EasyMock.createNiceMock(BrowserLauncher.class);
            }

            protected BrowserLauncher getBrowserLauncher(String browser, String sessionId, RemoteControlConfiguration configuration, BrowserConfigurationOptions browserOptions) {
                return this.browserLauncher;
            }

            protected void sleepTight(long timeoutInMs) {
            }

            protected void writeResults(File outputFile) throws IOException {
            }
        };
        EasyMock.expect((Object)this.remoteControl.getConfiguration()).andReturn((Object)this.configuration);
    }

    private void expectOutputFileBehavior() throws Exception {
        this.outputFile = (File)EasyMock.createStrictMock(File.class);
        EasyMock.expect((Object)this.outputFile.createNewFile()).andReturn((Object)true);
        EasyMock.expect((Object)this.outputFile.canWrite()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.outputFile});
    }

    @Test(expected=IOException.class)
    public void runHTMLSuite_throwsExceptionPriorToExecutionWhenOutputFileDoesntExist() throws Exception {
        this.outputFile = (File)EasyMock.createStrictMock(File.class);
        EasyMock.expect((Object)this.outputFile.createNewFile()).andReturn((Object)true);
        EasyMock.expect((Object)this.outputFile.canWrite()).andReturn((Object)false);
        EasyMock.expect((Object)this.outputFile.getAbsolutePath()).andReturn((Object)"");
        EasyMock.replay((Object[])new Object[]{this.outputFile});
        this.executeAndVerify();
    }

    @Test
    public void runHTMLSuite_copiesRemoteControlConfigurationToBrowserOptions() throws Exception {
        this.expectOutputFileBehavior();
        this.configuration.copySettingsIntoBrowserOptions((BrowserConfigurationOptions)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        this.executeAndVerify();
    }

    @Test
    public void runHTMLSuite_writesTestResultsWithFileWriter() throws Exception {
        this.expectOutputFileBehavior();
        this.launcher = new HTMLLauncher(this.remoteControl){
            final BrowserLauncher browserLauncher;
            final FileWriter writer;
            {
                this.browserLauncher = (BrowserLauncher)EasyMock.createNiceMock(BrowserLauncher.class);
                this.writer = (FileWriter)EasyMock.createMock(FileWriter.class);
            }

            protected BrowserLauncher getBrowserLauncher(String browser, String sessionId, RemoteControlConfiguration configuration, BrowserConfigurationOptions browserOptions) {
                return this.browserLauncher;
            }

            protected void sleepTight(long timeoutInMs) {
            }

            protected FileWriter getFileWriter(File outputFile) throws IOException {
                return this.writer;
            }
        };
        this.results.write((Writer)((FileWriter)EasyMock.anyObject()));
        EasyMock.expectLastCall().once();
        this.executeAndVerify();
    }

    private void executeAndVerify() throws Exception {
        EasyMock.expect((Object)this.results.getResult()).andReturn((Object)"");
        EasyMock.replay((Object[])new Object[]{this.results});
        this.launcher.setResults(this.results);
        EasyMock.replay((Object[])new Object[]{this.configuration});
        EasyMock.replay((Object[])new Object[]{this.remoteControl});
        this.launcher.runHTMLSuite("", "", "", this.outputFile, 5, true);
        EasyMock.verify((Object[])new Object[]{this.results});
        EasyMock.verify((Object[])new Object[]{this.configuration});
        EasyMock.verify((Object[])new Object[]{this.remoteControl});
        EasyMock.verify((Object[])new Object[]{this.outputFile});
    }
}

