/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.mock;

import java.io.File;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.log.LoggingManager;
import org.openqa.selenium.server.log.StdOutHandler;
import org.openqa.selenium.server.log.TerseFormatter;
import org.openqa.selenium.server.mock.BrowserRequest;
import org.openqa.selenium.server.mock.DriverRequest;
import org.openqa.selenium.server.mock.DummyBrowserLauncher;
import org.openqa.selenium.server.mock.MockPIFrame;

public class MockPIFrameUnitTest
extends TestCase {
    static final Log LOGGER = LogFactory.getLog(MockPIFrameUnitTest.class);
    private static final String DRIVER_URL = "http://localhost:4444/selenium-server/driver/";
    private static int timeoutInSeconds = 10;
    private String sessionId;
    private SeleniumServer server;

    public MockPIFrameUnitTest(String name) {
        super(name);
    }

    public static Test suitex() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new MockPIFrameUnitTest("testClickAndPause"));
        return suite;
    }

    public void setUp() throws Exception {
        this.configureLogging();
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setTimeoutInSeconds(timeoutInSeconds);
        configuration.setProxyInjectionModeArg(true);
        this.server = new SeleniumServer(false, configuration);
        this.server.start();
        BrowserLauncherFactory.addBrowserLauncher((String)"dummy", DummyBrowserLauncher.class);
        InjectionHelper.setFailOnError((boolean)false);
        LOGGER.info((Object)("Starting " + this.getName()));
    }

    private RemoteControlConfiguration configureLogging() throws Exception {
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        File target = new File("target");
        if (target.exists() && target.isDirectory()) {
            configuration.setLogOutFile(new File(target, "mockpiframe.log"));
        } else {
            configuration.setLogOutFile(new File("mockpiframe.log"));
        }
        LoggingManager.configureLogging((RemoteControlConfiguration)configuration, (boolean)false);
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof StdOutHandler)) continue;
            handler.setFormatter((Formatter)new TerseFormatter(true));
            break;
        }
        return configuration;
    }

    public void tearDown() {
        this.server.stop();
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)false);
        DummyBrowserLauncher.clearSessionId();
        InjectionHelper.setFailOnError((boolean)true);
    }

    public void testStartSession() {
        this.startSession();
    }

    public MockPIFrame startSession() {
        DriverRequest driverRequest = this.sendCommand("getNewBrowserSession", "*dummy", "http://x");
        this.sessionId = this.waitForSessionId(driverRequest);
        LOGGER.debug((Object)("browser starting session " + this.sessionId));
        MockPIFrame frame = new MockPIFrame(DRIVER_URL, this.sessionId, "frame1");
        LOGGER.debug((Object)"browser sending start message");
        frame.seleniumStart();
        LOGGER.debug((Object)"browser expecting getTitle command, blocking..");
        frame.expectCommand("getTitle", "", "");
        frame.sendResult("OK,selenium remote runner");
        frame.expectCommand("setContext", this.sessionId, "");
        frame.sendResult("OK");
        driverRequest.expectResult("OK," + this.sessionId);
        return frame;
    }

    public void testRegularOpen() {
        this.openUrl();
    }

    private MockPIFrame openUrl() {
        MockPIFrame frame1 = this.startSession();
        DriverRequest driverRequest = this.sendCommand("open", "blah.html", "");
        frame1.expectCommand("open", "blah.html", "");
        frame1.sendResult("OK");
        frame1.sendClose();
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        frame2.seleniumStart();
        frame2.expectCommand("getTitle", "", "");
        frame2.sendResult("OK,blah.html");
        driverRequest.expectResult("OK");
        return frame2;
    }

    public void testEvilOpen() {
        MockPIFrame frame1 = this.startSession();
        DriverRequest driverRequest = this.sendCommand("open", "blah.html", "");
        frame1.expectCommand("open", "blah.html", "");
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        frame2.seleniumStart();
        this.sleepForAtLeast(100L);
        frame1.sendResult("OK");
        frame2.expectCommand("getTitle", "", "");
        frame2.sendResult("OK,blah.html");
        driverRequest.expectResult("OK");
    }

    public void testClickThenWait() {
        MockPIFrame frame1 = this.startSession();
        DriverRequest driverRequest = this.sendCommand("click", "foo", "");
        frame1.expectCommand("click", "foo", "");
        frame1.sendResult("OK");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("waitForPageToLoad", "5000", "");
        frame1.sendClose().expectCommand("testComplete", "", "");
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        frame2.seleniumStart();
        frame2.expectCommand("getTitle", "", "");
        frame2.sendResult("OK,newpage.html");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("click", "bar", "");
        frame2.expectCommand("click", "bar", "");
        frame2.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    public void testEvilClickThenWait() {
        MockPIFrame frame1 = this.startSession();
        BrowserRequest browserRequest = frame1.getMostRecentRequest();
        DriverRequest driverRequest = this.sendCommand("click", "foo", "");
        browserRequest.expectCommand("click", "foo", "");
        frame1.sendResult("OK");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("waitForPageToLoad", "5000", "");
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        browserRequest = frame2.seleniumStart();
        this.sleepForAtLeast(100L);
        frame1.sendClose().expectCommand("testComplete", "", "");
        browserRequest.expectCommand("getTitle", "", "");
        browserRequest = frame2.sendResult("OK,newpage.html");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("click", "bar", "");
        browserRequest.expectCommand("click", "bar", "");
        frame2.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    public void testEvilClickThenWaitRaceCondition() throws InterruptedException {
        MockPIFrame frame1 = this.startSession();
        BrowserRequest browserRequest = frame1.getMostRecentRequest();
        DriverRequest driverRequest = this.sendCommand("click", "foo", "");
        browserRequest.expectCommand("click", "foo", "");
        int sequenceNumber = frame1.getSequenceNumber();
        frame1.setSequenceNumber(sequenceNumber + 1);
        frame1.sendClose();
        this.sleepForAtLeast(100L);
        frame1.setSequenceNumber(sequenceNumber);
        frame1.sendResult("OK");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("waitForPageToLoad", "5000", "");
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        browserRequest = frame2.seleniumStart();
        browserRequest.expectCommand("getTitle", "", "");
        browserRequest = frame2.sendResult("OK,newpage.html");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("click", "bar", "");
        browserRequest.expectCommand("click", "bar", "");
        frame2.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    public void testClickAndPause() {
        MockPIFrame frame1 = this.startSession();
        BrowserRequest browserRequest = frame1.getMostRecentRequest();
        DriverRequest driverRequest = this.sendCommand("click", "foo", "");
        browserRequest.expectCommand("click", "foo", "");
        frame1.sendResult("OK");
        driverRequest.expectResult("OK");
        frame1.sendClose();
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        browserRequest = frame2.seleniumStart();
        this.sleepForAtLeast(100L);
        driverRequest = this.sendCommand("click", "bar", "");
        browserRequest.expectCommand("getTitle", "", "");
        browserRequest = frame2.sendResult("OK,blah");
        browserRequest.expectCommand("click", "bar", "");
        frame2.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    public void testClickAndPauseThenWait() {
        MockPIFrame frame1 = this.startSession();
        BrowserRequest browserRequest = frame1.getMostRecentRequest();
        DriverRequest driverRequest = this.sendCommand("click", "foo", "");
        browserRequest.expectCommand("click", "foo", "");
        frame1.sendResult("OK");
        driverRequest.expectResult("OK");
        frame1.sendClose();
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        browserRequest = frame2.seleniumStart();
        this.sleepForAtLeast(100L);
        driverRequest = this.sendCommand("waitForPageToLoad", "5000", "");
        browserRequest.expectCommand("getTitle", "", "");
        browserRequest = frame2.sendResult("OK,newpage.html");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("click", "bar", "");
        browserRequest.expectCommand("click", "bar", "");
        frame2.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    public void testClickForgetToWait() {
        MockPIFrame frame1 = this.startSession();
        BrowserRequest browserRequest = frame1.getMostRecentRequest();
        DriverRequest driverRequest = this.sendCommand("click", "foo", "");
        browserRequest.expectCommand("click", "foo", "");
        frame1.sendResult("OK");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("click", "bar", "");
        frame1.sendClose();
        driverRequest.expectResult("Current window or frame is closed!");
        this.sendCommand("click", "bar", "").expectResult("Current window or frame is closed!");
        this.sendCommand("click", "bar", "").expectResult("Current window or frame is closed!");
        MockPIFrame frame2 = new MockPIFrame(DRIVER_URL, this.sessionId, "frame2");
        browserRequest = frame2.seleniumStart();
        this.sleepForAtLeast(100L);
        driverRequest = this.sendCommand("click", "bar", "");
        browserRequest.expectCommand("getTitle", "", "");
        browserRequest = frame2.sendResult("OK,blah");
        browserRequest.expectCommand("click", "bar", "");
        frame2.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    public void testRetryLast() throws Exception {
        MockPIFrame frame = this.startSession();
        DriverRequest getTitle = this.sendCommand("getTitle", "", "");
        frame.expectCommand("getTitle", "", "");
        frame.sendResult("OK,foo");
        getTitle.expectResult("OK,foo");
        frame.expectCommand("retryLast", "", "");
        frame.sendRetry();
        DriverRequest click = this.sendCommand("click", "foo", "");
        frame.expectCommand("click", "foo", "");
        frame.sendResult("OK");
        click.expectResult("OK");
    }

    public void testSetTimeout() throws Exception {
        MockPIFrame frame = this.startSession();
        int timeout = 4000;
        this.sendCommand("setTimeout", "100", "").expectResult("OK");
        DriverRequest open = this.sendCommand("open", "blah.html", "", timeout);
        frame.expectCommand("open", "blah.html", "");
        frame.sendResult("OK");
        this.sleepForAtLeast(timeout);
        String result = open.getResult();
        boolean hasTimeoutMessage = result.contains("timed out waiting for window");
        MockPIFrameUnitTest.assertTrue((String)"wrong error message on timeout", (boolean)hasTimeoutMessage);
    }

    public void testMultiWindow() throws Exception {
        MockPIFrame frame = this.openUrl();
        MockPIFrame subWindow = this.openSubWindow(frame);
        DriverRequest driverRequest1 = this.sendCommand("close", "", "");
        subWindow.expectCommand("close", "", "");
        subWindow.sendResult("OK");
        subWindow.sendClose();
        driverRequest1.expectResult("OK");
        this.sendCommand("selectWindow", "null", "").expectResult("OK");
        DriverRequest driverRequest = this.sendCommand("doubleClick", "", "");
        frame.expectCommand("doubleClick", "", "");
        frame.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    private void sleepForAtLeast(long ms) {
        if (ms > 0L) {
            long now = System.currentTimeMillis();
            long deadline = now + ms;
            while (now < deadline) {
                try {
                    Thread.sleep(deadline - now);
                    now = deadline;
                }
                catch (InterruptedException ie) {
                    now = System.currentTimeMillis();
                }
            }
        }
    }

    public void testEvilClosingWindow() throws Exception {
        MockPIFrame frame = this.startSession();
        MockPIFrame subWindow = this.openSubWindow(frame);
        BrowserRequest mainBrowserRequest = frame.getMostRecentRequest();
        DriverRequest driverRequest = this.sendCommand("close", "", "");
        subWindow.expectCommand("close", "", "");
        subWindow.sendResult("OK");
        subWindow.sendClose();
        driverRequest.expectResult("OK");
        this.sendCommand("doubleClick", "", "").expectResult("Current window or frame is closed!");
        this.sendCommand("doubleClick", "", "").expectResult("Current window or frame is closed!");
        this.sendCommand("selectWindow", "null", "").expectResult("OK");
        Thread.sleep(5L);
        mainBrowserRequest.expectCommand("retryLast", "", "");
        mainBrowserRequest = frame.sendRetry();
        driverRequest = this.sendCommand("submit", "", "");
        mainBrowserRequest.expectCommand("submit", "", "");
        Thread.sleep(timeoutInSeconds / 2);
        mainBrowserRequest = frame.sendResult("OK");
        driverRequest.expectResult("OK");
    }

    private MockPIFrame openSubWindow(MockPIFrame frame1) {
        DriverRequest driverRequest = this.sendCommand("click", "openWindow", "");
        frame1.expectCommand("click", "openWindow", "");
        frame1.sendResult("OK");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("waitForPopUp", "subWindow", "2000");
        MockPIFrame subWindow = new MockPIFrame(DRIVER_URL, this.sessionId, "subWindowId", "top", "subWindow");
        subWindow.seleniumStart();
        subWindow.expectCommand("getTitle", "", "");
        subWindow.sendResult("OK,Sub Window");
        driverRequest.expectResult("OK");
        this.sendCommand("selectWindow", "subWindow", "").expectResult("OK");
        driverRequest = this.sendCommand("type", "subWindowLink", "foo");
        subWindow.expectCommand("type", "subWindowLink", "foo");
        subWindow.sendResult("OK");
        driverRequest.expectResult("OK");
        return subWindow;
    }

    public SmallFrameSet openSubFrames() {
        MockPIFrame oldFrame = this.startSession();
        DriverRequest driverRequest = this.sendCommand("open", "frames.html", "");
        oldFrame.expectCommand("open", "frames.html", "");
        oldFrame.sendResult("OK");
        oldFrame.sendClose();
        MockPIFrame subFrame0 = new MockPIFrame(DRIVER_URL, this.sessionId, "subFrame0Id", "top.frames[0]", "");
        MockPIFrame subFrame1 = new MockPIFrame(DRIVER_URL, this.sessionId, "subFrame1Id", "top.frames[1]", "");
        subFrame0.seleniumStart();
        subFrame1.seleniumStart();
        MockPIFrame topFrame = new MockPIFrame(DRIVER_URL, this.sessionId, "frameId");
        topFrame.seleniumStart();
        topFrame.expectCommand("getTitle", "", "");
        topFrame.sendResult("OK,frames.html");
        driverRequest.expectResult("OK");
        SmallFrameSet set = new SmallFrameSet(topFrame, subFrame0, subFrame1);
        return set;
    }

    public void testSubFrames() {
        this.openSubFrames();
    }

    public void testFramesOpen() {
        SmallFrameSet set = this.openSubFrames();
        DriverRequest driverRequest = this.sendCommand("selectFrame", "subFrame1", "");
        set.topFrame.expectCommand("getWhetherThisFrameMatchFrameExpression", "top", "subFrame1");
        set.topFrame.sendResult("OK,false");
        set.subFrame0.expectCommand("getWhetherThisFrameMatchFrameExpression", "top", "subFrame1");
        set.subFrame0.sendResult("OK,false");
        set.subFrame1.expectCommand("getWhetherThisFrameMatchFrameExpression", "top", "subFrame1");
        set.subFrame1.sendResult("OK,true");
        driverRequest.expectResult("OK");
        driverRequest = this.sendCommand("open", "blah.html", "");
        set.subFrame1.expectCommand("open", "blah.html", "");
        set.subFrame1.sendResult("OK");
        set.subFrame1.sendClose();
        MockPIFrame newSubFrame1 = new MockPIFrame(DRIVER_URL, this.sessionId, "newSubFrame1", "top.frames[1]", "");
        newSubFrame1.seleniumStart();
        newSubFrame1.expectCommand("getTitle", "", "");
        newSubFrame1.sendResult("OK,blah.html");
        driverRequest.expectResult("OK");
    }

    public void XtestDoubleCommand() throws Exception {
        MockPIFrame frame = this.startSession();
        BrowserRequest browserRequest = frame.getMostRecentRequest();
        DriverRequest clickFoo = this.sendCommand("click", "foo", "");
        this.sleepForAtLeast(100L);
        DriverRequest clickBar = this.sendCommand("click", "bar", "");
        browserRequest.expectCommand("click", "foo", "");
        browserRequest = frame.sendResult("OK");
        browserRequest.expectCommand("click", "bar", "");
        frame.sendResult("OK");
        MockPIFrameUnitTest.assertEquals((String)"click foo result got mangled", (String)"OK", (String)clickFoo.getResult());
        MockPIFrameUnitTest.assertEquals((String)"click bar result got mangled", (String)"OK", (String)clickBar.getResult());
    }

    private String waitForSessionId(DriverRequest getNewBrowserSession) {
        String sessionId1;
        long now = System.currentTimeMillis();
        long timeout = 30000L;
        long finish = now + timeout;
        if (timeout == 0L) {
            finish = Long.MAX_VALUE;
        }
        this.sleepForAtLeast(10L);
        String result = null;
        while (System.currentTimeMillis() < finish) {
            sessionId1 = DummyBrowserLauncher.getSessionId();
            if (sessionId1 != null) {
                return sessionId1;
            }
            if (!getNewBrowserSession.isAlive()) {
                try {
                    result = getNewBrowserSession.getResult();
                }
                catch (Exception e) {
                    throw new RuntimeException("sessionId never appeared", e);
                }
                throw new RuntimeException("sessionId never appeared, getNewBrowserSession said: " + result);
            }
            this.sleepForAtLeast(10L);
        }
        sessionId1 = DummyBrowserLauncher.getSessionId();
        if (sessionId1 != null) {
            return sessionId1;
        }
        try {
            result = getNewBrowserSession.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException("sessionId never appeared", e);
        }
        throw new RuntimeException("sessionId never appeared, getNewBrowserSession said: " + result);
    }

    private DriverRequest sendCommand(String cmd, String arg1, String arg2, int timeoutInMillis) {
        return this.sendCommand((RemoteCommand)new DefaultRemoteCommand(cmd, arg1, arg2), timeoutInMillis);
    }

    private DriverRequest sendCommand(String cmd, String arg1, String arg2) {
        return this.sendCommand((RemoteCommand)new DefaultRemoteCommand(cmd, arg1, arg2), 30000);
    }

    private DriverRequest sendCommand(RemoteCommand cmd, int timeoutInMillis) {
        LOGGER.info((Object)("Driver sends " + cmd + " on session " + this.sessionId));
        return DriverRequest.request(DRIVER_URL, cmd, this.sessionId, timeoutInMillis);
    }

    private class SmallFrameSet {
        MockPIFrame topFrame;
        MockPIFrame subFrame0;
        MockPIFrame subFrame1;

        public SmallFrameSet(MockPIFrame topFrame, MockPIFrame subFrame0, MockPIFrame subFrame1) {
            this.topFrame = topFrame;
            this.subFrame0 = subFrame0;
            this.subFrame1 = subFrame1;
        }
    }
}

