/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.ResourceCache;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.util.Resource;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.ResourceLocator;

public class StaticContentHandler
extends ResourceHandler {
    private static final long serialVersionUID = 8031049889874827358L;
    private static boolean slowResources;
    private List<ResourceLocator> resourceLocators = new ArrayList<ResourceLocator>();
    public static final int SERVER_DELAY = 1000;
    private final String debugURL;
    private final boolean proxyInjectionMode;

    public StaticContentHandler(String debugURL, boolean proxyInjectionMode) {
        this.debugURL = debugURL;
        this.proxyInjectionMode = proxyInjectionMode;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        this.hackRemoveLastModifiedSince(httpRequest);
        this.setNoCacheHeaders(httpResponse);
        if (pathInContext.equals("/core/RemoteRunner.html") && this.proxyInjectionMode) {
            pathInContext = pathInContext.replaceFirst("/core/RemoteRunner.html", "/core/InjectedRemoteRunner.html");
        }
        this.callSuperHandle(pathInContext, pathParams, httpRequest, httpResponse);
        String resourceName = this.getResource(pathInContext).getName();
        if (resourceName.endsWith("MISSING RESOURCE")) {
            httpResponse.setAttribute("NotFound", "True");
        }
    }

    protected void callSuperHandle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        super.handle(pathInContext, pathParams, httpRequest, httpResponse);
    }

    private void hackRemoveLastModifiedSince(HttpRequest req) {
        if (null == req.getField("If-Modified-Since")) {
            return;
        }
        try {
            Field f = HttpMessage.class.getDeclaredField("_header");
            f.setAccessible(true);
            HttpFields header = (HttpFields)f.get(req);
            header.remove("If-Modified-Since");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setNoCacheHeaders(HttpResponse res) {
        res.setField("Cache-Control", "no-cache");
        res.setField("Pragma", "no-cache");
        res.setField("Expires", HttpFields.__01Jan1970);
    }

    protected Resource getResource(String pathInContext) throws IOException {
        this.delayIfNeed(pathInContext);
        for (int i = this.resourceLocators.size() - 1; i >= 0; --i) {
            ResourceLocator resourceLocator = this.resourceLocators.get(i);
            Resource resource = resourceLocator.getResource(this.getHttpContext(), pathInContext);
            if (!resource.exists()) continue;
            return resource;
        }
        return Resource.newResource("MISSING RESOURCE");
    }

    private void delayIfNeed(String pathInContext) {
        if (slowResources) {
            this.pause(1000);
            if (pathInContext != null && pathInContext.endsWith("slow.html")) {
                this.pause(1000);
            }
        }
    }

    private void pause(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addStaticContent(ResourceLocator locator) {
        this.resourceLocators.add(locator);
    }

    public void sendData(HttpRequest request, HttpResponse response, String pathInContext, Resource resource, boolean writeHeaders) throws IOException {
        if (!this.proxyInjectionMode) {
            super.sendData(request, response, pathInContext, resource, writeHeaders);
            return;
        }
        ResourceCache.ResourceMetaData metaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
        String mimeType = metaData.getMimeType();
        response.setContentType(mimeType);
        if (resource.length() != -1L) {
            response.setField("Content-Length", metaData.getLength());
        }
        InjectionHelper.injectJavaScript(request, response, resource.getInputStream(), response.getOutputStream(), this.debugURL);
        request.setHandled(true);
    }

    public static void setSlowResources(boolean slowResources) {
        StaticContentHandler.slowResources = slowResources;
    }

    public static boolean getSlowResources() {
        return slowResources;
    }
}

