/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.Cleanly;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandler {
    private static final Method JDK6_SETWRITABLE = FileHandler.findJdk6SetWritableMethod();
    private static final File CHMOD_SETWRITABLE = FileHandler.findChmodCommand();

    public static File unzip(InputStream resource) throws IOException {
        File output = TemporaryFilesystem.getDefaultTmpFS().createTempDir("unzip", "stream");
        new Zip().unzip(resource, output);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(File outputDir, Class<?> forClassLoader, String ... names) throws IOException {
        Zip zip = new Zip();
        for (String name : names) {
            InputStream is = FileHandler.locateResource(forClassLoader, name);
            try {
                zip.unzipFile(outputDir, is, name);
            }
            finally {
                Cleanly.close(is);
            }
        }
    }

    private static InputStream locateResource(Class<?> forClassLoader, String name) throws IOException {
        String[] alternatives;
        String arch = System.getProperty("os.arch").toLowerCase() + "/";
        for (String possibility : alternatives = new String[]{name, "/" + name, arch + name, "/" + arch + name}) {
            InputStream stream = FileHandler.class.getResourceAsStream(possibility);
            if (stream != null) {
                return stream;
            }
            stream = forClassLoader.getResourceAsStream(possibility);
            if (stream == null) continue;
            return stream;
        }
        throw new IOException("Unable to locate: " + name);
    }

    public static boolean createDir(File dir) throws IOException {
        if ((dir.exists() || dir.mkdirs()) && dir.canWrite()) {
            return true;
        }
        if (dir.exists()) {
            FileHandler.makeWritable(dir);
            return dir.canWrite();
        }
        return FileHandler.createDir(dir.getParentFile());
    }

    public static boolean makeWritable(File file) throws IOException {
        block8: {
            if (file.canWrite()) {
                return true;
            }
            if (JDK6_SETWRITABLE != null) {
                try {
                    return (Boolean)JDK6_SETWRITABLE.invoke((Object)file, true);
                }
                catch (IllegalAccessException e) {
                    break block8;
                }
                catch (InvocationTargetException e) {
                    break block8;
                }
            }
            if (CHMOD_SETWRITABLE != null) {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{CHMOD_SETWRITABLE.getAbsolutePath(), "+x", file.getAbsolutePath()});
                    process.waitFor();
                    return file.canWrite();
                }
                catch (InterruptedException e1) {
                    throw new WebDriverException((Throwable)e1);
                }
            }
        }
        return false;
    }

    public static boolean isZipped(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".xpi");
    }

    public static boolean delete(File toDelete) {
        boolean deleted = true;
        if (toDelete.isDirectory()) {
            for (File child : toDelete.listFiles()) {
                deleted &= child.canWrite() && FileHandler.delete(child);
            }
        }
        return deleted && toDelete.canWrite() && toDelete.delete();
    }

    public static void copy(File from, File to) throws IOException {
        FileHandler.copy(from, to, new NoFilter());
    }

    public static void copy(File source, File dest, String suffix) throws IOException {
        FileHandler.copy(source, dest, suffix == null ? new NoFilter() : new FileSuffixFilter(suffix));
    }

    private static void copy(File source, File dest, Filter onlyCopy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            FileHandler.copyDir(source, dest, onlyCopy);
        } else {
            FileHandler.copyFile(source, dest, onlyCopy);
        }
    }

    private static void copyDir(File from, File to, Filter onlyCopy) throws IOException {
        String[] children;
        if (!onlyCopy.isRequired(from)) {
            return;
        }
        FileHandler.createDir(to);
        for (String child : children = from.list()) {
            if (".parentlock".equals(child) || "parent.lock".equals(child)) continue;
            FileHandler.copy(new File(from, child), new File(to, child), onlyCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File from, File to, Filter onlyCopy) throws IOException {
        if (!onlyCopy.isRequired(from)) {
            return;
        }
        FileChannel out = null;
        FileChannel in = null;
        try {
            in = new FileInputStream(from).getChannel();
            out = new FileOutputStream(to).getChannel();
            long length = in.size();
            long copied = in.transferTo(0L, in.size(), out);
            if (copied != length) {
                throw new IOException("Could not transfer all bytes.");
            }
        }
        catch (Throwable throwable) {
            Cleanly.close(out);
            Cleanly.close(in);
            throw throwable;
        }
        Cleanly.close(out);
        Cleanly.close(in);
    }

    private static Method findJdk6SetWritableMethod() {
        try {
            return File.class.getMethod("setWritable", Boolean.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static File findChmodCommand() {
        String[] paths;
        String allPaths = System.getenv("PATH");
        for (String path : paths = allPaths.split(File.pathSeparator)) {
            File chmod = new File(path, "chmod");
            if (!chmod.exists()) continue;
            return chmod;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(File toRead) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            int read;
            reader = new BufferedReader(new FileReader(toRead));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                char[] target = new char[read];
                System.arraycopy(buffer, 0, target, 0, read);
                builder.append(target);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            Cleanly.close(reader);
            throw throwable;
        }
        Cleanly.close(reader);
        return string;
    }

    private static class NoFilter
    implements Filter {
        private NoFilter() {
        }

        public boolean isRequired(File file) {
            return true;
        }
    }

    private static class FileSuffixFilter
    implements Filter {
        private final String suffix;

        public FileSuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean isRequired(File file) {
            return file.isDirectory() || file.getAbsolutePath().endsWith(this.suffix);
        }
    }

    public static interface Filter {
        public boolean isRequired(File var1);
    }
}

