/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWebElement
implements WebElement,
FindsByLinkText,
FindsById,
FindsByName,
FindsByTagName,
FindsByClassName,
FindsByCssSelector,
FindsByXPath,
WrapsDriver {
    protected String id;
    protected RemoteWebDriver parent;
    protected RemoteWebDriver.RemoteMouse mouse;

    public void setParent(RemoteWebDriver parent) {
        this.parent = parent;
        this.mouse = (RemoteWebDriver.RemoteMouse)parent.getMouse();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void click() {
        this.execute("clickElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public void submit() {
        this.execute("submitElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public String getValue() {
        return (String)this.execute("getElementValue", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.execute("sendKeysToElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"value", (Object)keysToSend));
    }

    public void clear() {
        this.execute("clearElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public String getTagName() {
        return (String)this.execute("getElementTagName", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public String getAttribute(String name) {
        Object value = this.execute("getElementAttribute", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"name", (Object)name)).getValue();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public boolean toggle() {
        return (Boolean)this.execute("toggleElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public boolean isSelected() {
        return (Boolean)this.execute("isElementSelected", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public void setSelected() {
        this.execute("setElementSelected", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public boolean isEnabled() {
        return (Boolean)this.execute("isElementEnabled", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public String getText() {
        Response response = this.execute("getElementText", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        return (String)response.getValue();
    }

    public String getCssValue(String propertyName) {
        Response response = this.parent.execute("getElementValueOfCssProperty", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"propertyName", (Object)propertyName));
        return (String)response.getValue();
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(String using, String value) {
        Response response = this.execute("findChildElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)using, (Object)"value", (Object)value));
        return (WebElement)response.getValue();
    }

    protected List<WebElement> findElements(String using, String value) {
        Response response = this.execute("findChildElements", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)using, (Object)"value", (Object)value));
        return (List)response.getValue();
    }

    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    public WebElement findElementByClassName(String using) {
        return this.findElement("class name", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("class name", using);
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css selector", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css selector", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    protected Response execute(String command, Map<String, ?> parameters) {
        return this.parent.execute(command, parameters);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        if (!(other instanceof RemoteWebElement)) {
            return false;
        }
        Response response = this.execute("elementEquals", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"other", (Object)((RemoteWebElement)other).id));
        Object value = response.getValue();
        return value != null && value instanceof Boolean && (Boolean)value != false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    public boolean isDisplayed() {
        Response response = this.parent.execute("isElementDisplayed", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        return (Boolean)response.getValue();
    }

    public Point getLocation() {
        Response response = this.parent.execute("getElementLocation", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawPoint = (Map)response.getValue();
        int x = ((Long)rawPoint.get("x")).intValue();
        int y = ((Long)rawPoint.get("y")).intValue();
        return new Point(x, y);
    }

    public Dimension getSize() {
        Response response = this.parent.execute("getElementSize", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawSize = (Map)response.getValue();
        int width = ((Long)rawSize.get("width")).intValue();
        int height = ((Long)rawSize.get("height")).intValue();
        return new Dimension(width, height);
    }
}

