/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.html5;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.DatabaseStorage;
import org.openqa.selenium.html5.ResultSet;
import org.openqa.selenium.html5.ResultSetRows;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

public class RemoteDatabaseStorage
implements DatabaseStorage {
    private final ExecuteMethod executeMethod;

    public RemoteDatabaseStorage(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    public ResultSet executeSQL(String databaseName, String query, Object ... args) throws WebDriverException {
        query = query.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params = ImmutableMap.of((Object)"dbName", (Object)databaseName, (Object)"query", (Object)query, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        Map resultAsMap = (Map)this.executeMethod.execute("executeSQL", (Map<String, ?>)params);
        List rows = (List)resultAsMap.get("rows");
        return new ResultSet(((Number)resultAsMap.get("insertId")).intValue(), ((Number)resultAsMap.get("rowsAffected")).intValue(), new ResultSetRows(rows));
    }
}

