/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;

public class JsonInput
implements Closeable {
    private final Gson gson;
    private final JsonReader jsonReader;

    JsonInput(Gson gson, JsonReader jsonReader) {
        this.gson = gson;
        this.jsonReader = jsonReader;
    }

    @Override
    public void close() {
        try {
            this.jsonReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void beginObject() {
        try {
            this.jsonReader.beginObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void endObject() {
        try {
            this.jsonReader.endObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void beginArray() {
        try {
            this.jsonReader.beginArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void endArray() {
        try {
            this.jsonReader.endArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean hasNext() {
        try {
            return this.jsonReader.hasNext();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String nextName() {
        try {
            return this.jsonReader.nextName();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T read(Type type) {
        return (T)this.gson.fromJson(this.jsonReader, type);
    }

    public void skipValue() {
        try {
            this.jsonReader.skipValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

