/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import org.openqa.selenium.json.BeanToJsonConverter;
import org.openqa.selenium.json.JsonInput;

public class JsonOutput
implements Closeable {
    private final JsonWriter jsonWriter;
    private final BeanToJsonConverter toJson;

    JsonOutput(BeanToJsonConverter toJson, JsonWriter jsonWriter) {
        this.jsonWriter = jsonWriter;
        this.jsonWriter.setIndent("  ");
        this.toJson = toJson;
    }

    @Override
    public void close() throws IOException {
        this.jsonWriter.close();
    }

    public JsonOutput write(JsonInput input, Type type) {
        try {
            Object read = input.read(type);
            this.jsonWriter.jsonValue(this.toJson.convert(read));
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonOutput write(Object input, Type type) {
        try {
            this.jsonWriter.jsonValue(this.toJson.convert(input));
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonOutput beginObject() {
        try {
            this.jsonWriter.beginObject();
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonOutput endObject() {
        try {
            this.jsonWriter.endObject();
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonOutput name(String name) {
        try {
            this.jsonWriter.name(name);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonOutput beginArray() {
        try {
            this.jsonWriter.beginArray();
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonOutput endArray() {
        try {
            this.jsonWriter.endArray();
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

