/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.JsonWireProtocolResponse;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.W3CHandshakeResponse;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ProtocolHandshake {
    private static final Logger LOG = Logger.getLogger(ProtocolHandshake.class.getName());

    public Result createSession(HttpHandler client, Command command) throws IOException {
        Capabilities desired = (Capabilities)command.getParameters().get("desiredCapabilities");
        desired = desired == null ? new ImmutableCapabilities() : desired;
        try (NewSessionPayload payload = NewSessionPayload.create(desired);){
            Either<SessionNotCreatedException, Result> result = this.createSession(client, payload);
            if (result.isRight()) {
                Result toReturn = (Result)result.right();
                LOG.info(String.format("Detected dialect: %s", new Object[]{toReturn.dialect}));
                Result result2 = toReturn;
                return result2;
            }
            throw (SessionNotCreatedException)result.left();
        }
    }

    /*
     * Exception decompiling
     */
    public Either<SessionNotCreatedException, Result> createSession(HttpHandler client, NewSessionPayload payload) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Either<SessionNotCreatedException, Result> createSession(HttpHandler client, InputStream newSessionBlob, long size) {
        Map blob;
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/session");
        long start = System.currentTimeMillis();
        request.setHeader("Content-Length", String.valueOf(size));
        request.setHeader("Content-Type", "application/json; charset=utf-8");
        request.setContent(() -> newSessionBlob);
        HttpResponse response = client.execute(request);
        long time = System.currentTimeMillis() - start;
        try {
            blob = (Map)new Json().toType(Contents.string((HttpMessage)response), Map.class);
        }
        catch (JsonException e) {
            return Either.left((Object)new SessionNotCreatedException("Unable to parse remote response: " + Contents.string((HttpMessage)response), (Throwable)e));
        }
        InitialHandshakeResponse initialResponse = new InitialHandshakeResponse(time, response.getStatus(), blob);
        if (initialResponse.getStatusCode() != 200) {
            Object rawResponseValue = initialResponse.getData().get("value");
            String responseMessage = rawResponseValue instanceof Map ? ((Map)rawResponseValue).get("message").toString() : new Json().toJson(rawResponseValue);
            return Either.left((Object)new SessionNotCreatedException(String.format("Response code %s. Message: %s", initialResponse.getStatusCode(), responseMessage)));
        }
        return Stream.of(new W3CHandshakeResponse().getResponseFunction(), new JsonWireProtocolResponse().getResponseFunction()).map(func -> (Result)func.apply(initialResponse)).filter(Objects::nonNull).findFirst().map(Either::right).orElseGet(() -> Either.left((Object)new SessionNotCreatedException("Handshake response does not match any supported protocol")));
    }

    public static class Result {
        private static final Function<Object, Proxy> massageProxy = obj -> {
            if (obj instanceof Proxy) {
                return (Proxy)obj;
            }
            if (!(obj instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)obj;
            for (Object key : rawMap.keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            return new Proxy((Map)obj);
        };
        private final Dialect dialect;
        private final Map<String, ?> capabilities;
        private final SessionId sessionId;

        Result(Dialect dialect, String sessionId, Map<String, ?> capabilities) {
            this.dialect = dialect;
            this.sessionId = new SessionId((String)Require.nonNull((String)"Session id", (Object)sessionId));
            this.capabilities = capabilities;
            if (capabilities.containsKey("proxy")) {
                capabilities.put("proxy", massageProxy.apply(capabilities.get("proxy")));
            }
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public Response createResponse() {
            Response response = new Response(this.sessionId);
            response.setValue(this.capabilities);
            response.setStatus(0);
            response.setState("success");
            return response;
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.dialect, this.capabilities});
        }
    }
}

