/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.codec.jwp;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.remote.codec.AbstractHttpCommandCodec;

public class JsonHttpCommandCodec
extends AbstractHttpCommandCodec {
    public JsonHttpCommandCodec() {
        String sessionId = "/session/:sessionId";
        String elementId = sessionId + "/element/:id";
        this.defineCommand("getElementAttribute", JsonHttpCommandCodec.get(elementId + "/attribute/:name"));
        this.defineCommand("getElementLocationOnceScrolledIntoView", JsonHttpCommandCodec.get(elementId + "/location_in_view"));
        this.defineCommand("isElementDisplayed", JsonHttpCommandCodec.get(elementId + "/displayed"));
        this.defineCommand("submitElement", JsonHttpCommandCodec.post(elementId + "/submit"));
        this.defineCommand("executeScript", JsonHttpCommandCodec.post(sessionId + "/execute"));
        this.defineCommand("executeAsyncScript", JsonHttpCommandCodec.post(sessionId + "/execute_async"));
        this.defineCommand("getPageSource", JsonHttpCommandCodec.get(sessionId + "/source"));
        String windowHandle = sessionId + "/window/:windowHandle";
        this.defineCommand("maximizeCurrentWindow", JsonHttpCommandCodec.post(windowHandle + "/maximize"));
        this.defineCommand("getWindowPosition", JsonHttpCommandCodec.get(windowHandle + "/position"));
        this.defineCommand("setWindowPosition", JsonHttpCommandCodec.post(windowHandle + "/position"));
        this.defineCommand("getCurrentWindowSize", JsonHttpCommandCodec.get(windowHandle + "/size"));
        this.defineCommand("setCurrentWindowSize", JsonHttpCommandCodec.post(windowHandle + "/size"));
        this.defineCommand("getCurrentWindowHandle", JsonHttpCommandCodec.get(sessionId + "/window_handle"));
        this.defineCommand("getWindowHandles", JsonHttpCommandCodec.get(sessionId + "/window_handles"));
        this.defineCommand("acceptAlert", JsonHttpCommandCodec.post(sessionId + "/accept_alert"));
        this.defineCommand("dismissAlert", JsonHttpCommandCodec.post(sessionId + "/dismiss_alert"));
        this.defineCommand("getAlertText", JsonHttpCommandCodec.get(sessionId + "/alert_text"));
        this.defineCommand("setAlertValue", JsonHttpCommandCodec.post(sessionId + "/alert_text"));
        this.defineCommand("uploadFile", JsonHttpCommandCodec.post(sessionId + "/file"));
        this.defineCommand("getActiveElement", JsonHttpCommandCodec.post(sessionId + "/element/active"));
        String localStorage = sessionId + "/local_storage";
        this.defineCommand("clearLocalStorage", JsonHttpCommandCodec.delete(localStorage));
        this.defineCommand("getLocalStorageKeys", JsonHttpCommandCodec.get(localStorage));
        this.defineCommand("setLocalStorageItem", JsonHttpCommandCodec.post(localStorage));
        this.defineCommand("removeLocalStorageItem", JsonHttpCommandCodec.delete(localStorage + "/key/:key"));
        this.defineCommand("getLocalStorageItem", JsonHttpCommandCodec.get(localStorage + "/key/:key"));
        this.defineCommand("getLocalStorageSize", JsonHttpCommandCodec.get(localStorage + "/size"));
        String sessionStorage = sessionId + "/session_storage";
        this.defineCommand("clearSessionStorage", JsonHttpCommandCodec.delete(sessionStorage));
        this.defineCommand("getSessionStorageKey", JsonHttpCommandCodec.get(sessionStorage));
        this.defineCommand("setSessionStorageItem", JsonHttpCommandCodec.post(sessionStorage));
        this.defineCommand("removeSessionStorageItem", JsonHttpCommandCodec.delete(sessionStorage + "/key/:key"));
        this.defineCommand("getSessionStorageItem", JsonHttpCommandCodec.get(sessionStorage + "/key/:key"));
        this.defineCommand("getSessionStorageSize", JsonHttpCommandCodec.get(sessionStorage + "/size"));
        this.defineCommand("mouseButtonDown", JsonHttpCommandCodec.post(sessionId + "/buttondown"));
        this.defineCommand("mouseButtonUp", JsonHttpCommandCodec.post(sessionId + "/buttonup"));
        this.defineCommand("mouseClick", JsonHttpCommandCodec.post(sessionId + "/click"));
        this.defineCommand("mouseDoubleClick", JsonHttpCommandCodec.post(sessionId + "/doubleclick"));
        this.defineCommand("mouseMoveTo", JsonHttpCommandCodec.post(sessionId + "/moveto"));
        this.defineCommand("sendKeysToActiveElement", JsonHttpCommandCodec.post(sessionId + "/keys"));
        String touch = sessionId + "/touch";
        this.defineCommand("touchSingleTap", JsonHttpCommandCodec.post(touch + "/click"));
        this.defineCommand("touchDoubleTap", JsonHttpCommandCodec.post(touch + "/doubleclick"));
        this.defineCommand("touchDown", JsonHttpCommandCodec.post(touch + "/down"));
        this.defineCommand("touchFlick", JsonHttpCommandCodec.post(touch + "/flick"));
        this.defineCommand("touchLongPress", JsonHttpCommandCodec.post(touch + "/longclick"));
        this.defineCommand("touchMove", JsonHttpCommandCodec.post(touch + "/move"));
        this.defineCommand("touchScroll", JsonHttpCommandCodec.post(touch + "/scroll"));
        this.defineCommand("touchUp", JsonHttpCommandCodec.post(touch + "/up"));
    }

    @Override
    protected Map<String, ?> amendParameters(String name, Map<String, ?> parameters) {
        switch (name) {
            case "getCurrentWindowSize": 
            case "maximizeCurrentWindow": 
            case "setCurrentWindowSize": 
            case "setWindowPosition": {
                return ImmutableMap.builder().putAll(parameters).put((Object)"windowHandle", (Object)"current").put((Object)"handle", (Object)"current").build();
            }
            case "setTimeout": {
                if (parameters.size() != 1) {
                    throw new InvalidArgumentException("The JSON wire protocol only supports setting one time out at a time");
                }
                Map.Entry<String, ?> entry = parameters.entrySet().iterator().next();
                String type = entry.getKey();
                if ("pageLoad".equals(type)) {
                    type = "page load";
                }
                return ImmutableMap.of((Object)"type", (Object)type, (Object)"ms", entry.getValue());
            }
            case "switchToWindow": {
                return ImmutableMap.builder().put((Object)"name", parameters.get("handle")).build();
            }
        }
        return parameters;
    }
}

