/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.codec.w3c;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.codec.AbstractHttpResponseCodec;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpResponse;

public class W3CHttpResponseCodec
extends AbstractHttpResponseCodec {
    private static final Logger LOG = Logger.getLogger(W3CHttpResponseCodec.class.getName());
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final Json json = new Json();
    private final Function<Object, Object> elementConverter = new JsonToWebElementConverter(null);

    @Override
    public Response decode(HttpResponse encodedResponse) {
        String content = Contents.string((HttpMessage)encodedResponse).trim();
        LOG.fine(String.format("Decoding response. Response code was: %d and content: %s", encodedResponse.getStatus(), content));
        String contentType = Strings.nullToEmpty((String)encodedResponse.getHeader("Content-Type"));
        Response response = new Response();
        if (!encodedResponse.isSuccessful()) {
            LOG.fine("Processing an error");
            if (405 == encodedResponse.getStatus()) {
                response.setStatus(9);
                response.setValue(content);
            } else if (504 == encodedResponse.getStatus() || 502 == encodedResponse.getStatus()) {
                response.setStatus(13);
                response.setValue(content);
            } else {
                Map obj = (Map)this.json.toType(content, Json.MAP_TYPE);
                Object w3cWrappedValue = obj.get("value");
                if (w3cWrappedValue instanceof Map && ((Map)w3cWrappedValue).containsKey("error")) {
                    obj = (Map)w3cWrappedValue;
                }
                String message = "An unknown error has occurred";
                if (obj.get("message") instanceof String) {
                    message = (String)obj.get("message");
                }
                String error = "unknown error";
                if (obj.get("error") instanceof String) {
                    error = (String)obj.get("error");
                }
                response.setState(error);
                response.setStatus(this.errorCodes.toStatus(error, Optional.of(encodedResponse.getStatus())));
                if ("unexpected alert open".equals(error) && 500 == encodedResponse.getStatus()) {
                    Object rawText;
                    String text = "";
                    Object data = obj.get("data");
                    if (data != null && (rawText = ((Map)data).get("text")) instanceof String) {
                        text = (String)rawText;
                    }
                    response.setValue(new UnhandledAlertException(message, text));
                } else {
                    response.setValue((Object)this.createException(error, message));
                }
            }
            return response;
        }
        response.setState("success");
        response.setStatus(0);
        if (!content.isEmpty() && contentType.startsWith("application/json")) {
            Map parsed = (Map)this.json.toType(content, Json.MAP_TYPE);
            if (parsed.containsKey("value")) {
                Object value = parsed.get("value");
                response.setValue(value);
            } else {
                response.setValue(this.json.toType(content, Json.OBJECT_TYPE));
            }
        }
        if (response.getValue() instanceof String) {
            response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
        }
        return response;
    }

    @Override
    protected Object getValueToEncode(Response response) {
        HashMap toReturn = new HashMap();
        HashMap<String, Object> value = response.getValue();
        if (value instanceof WebDriverException) {
            HashMap<String, Object> exception = new HashMap<String, Object>();
            exception.put("error", response.getState() != null ? response.getState() : this.errorCodes.toState(response.getStatus()));
            exception.put("message", ((WebDriverException)((Object)value)).getMessage());
            exception.put("stacktrace", Throwables.getStackTraceAsString((Throwable)((WebDriverException)((Object)value))));
            if (value instanceof UnhandledAlertException) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("text", ((UnhandledAlertException)value).getAlertText());
                exception.put("data", data);
            }
            value = exception;
        }
        toReturn.put("value", value);
        return toReturn;
    }

    @Override
    protected Response reconstructValue(Response response) {
        response.setValue(this.elementConverter.apply(response.getValue()));
        return response;
    }

    private WebDriverException createException(String error, String message) {
        Class<? extends WebDriverException> clazz = this.errorCodes.getExceptionType(error);
        try {
            Constructor<? extends WebDriverException> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(message);
        }
        catch (ReflectiveOperationException e) {
            throw new WebDriverException(message);
        }
    }
}

