/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.netty.NettyClient;

class NettyMessages {
    private NettyMessages() {
    }

    protected static Request toNettyRequest(ClientConfig config, HttpRequest request) {
        URI baseUrl = config.baseUri();
        int timeout = NettyClient.toClampedInt(config.readTimeout().toMillis());
        Credentials credentials = config.credentials();
        String rawUrl = NettyMessages.getRawUrl(baseUrl, request.getUri());
        RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.request((String)request.getMethod().toString(), (String)rawUrl).setReadTimeout(timeout)).setRequestTimeout(timeout);
        for (String name : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name)) {
                builder.addQueryParam(name, value);
            }
        }
        if (request.getMethod().equals((Object)HttpMethod.GET) && request.getHeader("Content-Length") != null) {
            request.removeHeader("Content-Length");
        }
        request.forEachHeader((arg_0, arg_1) -> ((RequestBuilder)builder).addHeader(arg_0, arg_1));
        if (request.getHeader("User-Agent") == null) {
            builder.addHeader((CharSequence)"User-Agent", AddSeleniumUserAgent.USER_AGENT);
        }
        Realm.Builder realmBuilder = null;
        String info = baseUrl.getUserInfo();
        if (!Strings.isNullOrEmpty((String)info)) {
            String[] parts = info.split(":", 2);
            String user = parts[0];
            String pass = parts.length > 1 ? parts[1] : null;
            realmBuilder = Dsl.basicAuthRealm((String)user, (String)pass).setUsePreemptiveAuth(true);
            builder.setRealm(realmBuilder);
        } else if (credentials != null) {
            if (!(credentials instanceof UsernameAndPassword)) {
                throw new IllegalArgumentException("Credentials must be a user name and password");
            }
            UsernameAndPassword uap = (UsernameAndPassword)credentials;
            realmBuilder = Dsl.basicAuthRealm((String)uap.username(), (String)uap.password()).setUsePreemptiveAuth(true);
            builder.setRealm(realmBuilder);
        }
        if (config.proxy() != null) {
            InetSocketAddress address = (InetSocketAddress)config.proxy().address();
            ProxyServer.Builder proxyBuilder = new ProxyServer.Builder(address.getHostName(), address.getPort());
            if (realmBuilder != null) {
                proxyBuilder.setRealm(realmBuilder);
            }
            builder.setProxyServer(proxyBuilder);
        }
        if (request.getMethod().equals((Object)HttpMethod.POST)) {
            builder.setBody((InputStream)request.getContent().get());
        }
        return builder.build();
    }

    public static HttpResponse toSeleniumResponse(Response response) {
        HttpResponse toReturn = new HttpResponse();
        toReturn.setStatus(response.getStatusCode());
        toReturn.setContent(!response.hasResponseBody() ? Contents.empty() : Contents.memoize(() -> ((Response)response).getResponseBodyAsStream()));
        response.getHeaders().names().forEach(name -> response.getHeaders((CharSequence)name).forEach(value -> toReturn.addHeader(name, value)));
        return toReturn;
    }

    private static String getRawUrl(URI baseUrl, String uri) {
        String base;
        String rawUrl = uri.startsWith("ws://") ? "http://" + uri.substring("ws://".length()) : (uri.startsWith("wss://") ? "https://" + uri.substring("wss://".length()) : (uri.startsWith("http://") || uri.startsWith("https://") ? uri : ((base = baseUrl.toString()).endsWith("/") ? base.substring(0, base.length() - 1) + uri : base + uri)));
        return rawUrl;
    }
}

