/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.bidi.browsingcontext.Locator;
import org.openqa.selenium.bidi.script.RemoteReference;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.bidi.script.SerializationOptions;

public class LocateNodeParameters {
    private final Locator locator;
    private Optional<Long> maxNodeCount = Optional.empty();
    private Optional<ResultOwnership> ownership = Optional.empty();
    private Optional<String> sandbox = Optional.empty();
    private Optional<SerializationOptions> serializationOptions = Optional.empty();
    private Optional<List<RemoteReference>> startNodes = Optional.empty();

    private LocateNodeParameters(Builder builder) {
        this.locator = builder.locator;
        this.maxNodeCount = Optional.ofNullable(builder.maxNodeCount);
        this.sandbox = Optional.ofNullable(builder.sandbox);
        this.serializationOptions = Optional.ofNullable(builder.serializationOptions);
        this.startNodes = Optional.ofNullable(builder.startNodes);
    }

    public LocateNodeParameters(Locator locator) {
        this.locator = locator;
    }

    public LocateNodeParameters setMaxNodeCount(long maxNodeCount) {
        this.maxNodeCount = Optional.of(maxNodeCount);
        return this;
    }

    public LocateNodeParameters setSandbox(String sandbox) {
        this.sandbox = Optional.of(sandbox);
        return this;
    }

    public LocateNodeParameters setSerializationOptions(SerializationOptions options) {
        this.serializationOptions = Optional.of(options);
        return this;
    }

    public LocateNodeParameters setStartNodes(List<RemoteReference> startNodes) {
        this.startNodes = Optional.of(startNodes);
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("locator", this.locator.toMap());
        this.maxNodeCount.ifPresent(value -> map.put("maxNodeCount", value));
        this.sandbox.ifPresent(value -> map.put("sandbox", value));
        this.serializationOptions.ifPresent(value -> map.put("serializationOptions", value.toJson()));
        this.startNodes.ifPresent(value -> {
            ArrayList startNodesJson = new ArrayList();
            value.forEach(remoteNode -> startNodesJson.add(remoteNode.toJson()));
            map.put("startNodes", startNodesJson);
        });
        return map;
    }

    @Deprecated(since="4.20", forRemoval=true)
    public static class Builder {
        private final Locator locator;
        private Long maxNodeCount = null;
        private String sandbox;
        private SerializationOptions serializationOptions;
        private List<RemoteReference> startNodes;

        public Builder(Locator locator) {
            this.locator = locator;
        }

        public Builder setMaxNodeCount(long maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
            return this;
        }

        public Builder setSandbox(String sandbox) {
            this.sandbox = sandbox;
            return this;
        }

        public Builder setSerializationOptions(SerializationOptions options) {
            this.serializationOptions = options;
            return this;
        }

        public Builder setStartNodes(List<RemoteReference> startNodes) {
            this.startNodes = startNodes;
            return this;
        }

        public LocateNodeParameters build() {
            return new LocateNodeParameters(this);
        }
    }
}

