/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.util.function.Function;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.idealized.Domains;
import org.openqa.selenium.internal.Require;

public abstract class CdpInfo
implements Comparable<CdpInfo> {
    private final int majorVersion;
    private final Function<DevTools, Domains> domains;

    protected CdpInfo(int majorVersion, Function<DevTools, Domains> domains) {
        this.majorVersion = majorVersion;
        this.domains = (Function)Require.nonNull((String)"Domain supplier", domains);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public Domains getDomains(DevTools devTools) {
        Require.nonNull((String)"DevTools", (Object)devTools);
        return this.domains.apply(devTools);
    }

    @Override
    public int compareTo(CdpInfo that) {
        return Integer.compare(this.getMajorVersion(), that.getMajorVersion());
    }

    public String toString() {
        return "CDP version: " + this.getMajorVersion();
    }
}

