/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;

class ElementLocation {
    private final Map<Class<? extends By>, ElementFinder> finders = new HashMap<Class<? extends By>, ElementFinder>();

    public ElementLocation() {
        this.finders.put(By.cssSelector((String)"a").getClass(), ElementFinder.REMOTE);
        this.finders.put(By.linkText((String)"a").getClass(), ElementFinder.REMOTE);
        this.finders.put(By.partialLinkText((String)"a").getClass(), ElementFinder.REMOTE);
        this.finders.put(By.tagName((String)"a").getClass(), ElementFinder.REMOTE);
        this.finders.put(By.xpath((String)"//a").getClass(), ElementFinder.REMOTE);
    }

    public WebElement findElement(RemoteWebDriver driver, SearchContext context, BiFunction<String, Object, CommandPayload> createPayload, By locator) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Context for finding elements", (Object)context);
        Require.nonNull((String)"Method for creating remote requests", createPayload);
        Require.nonNull((String)"Locator", (Object)locator);
        ElementFinder mechanism = this.finders.get(locator.getClass());
        if (mechanism != null) {
            return mechanism.findElement(driver, context, createPayload, locator);
        }
        if (locator instanceof By.Remotable) {
            try {
                WebElement element = ElementFinder.REMOTE.findElement(driver, context, createPayload, locator);
                this.finders.put(locator.getClass(), ElementFinder.REMOTE);
                return element;
            }
            catch (NoSuchElementException e) {
                this.finders.put(locator.getClass(), ElementFinder.REMOTE);
                throw e;
            }
            catch (InvalidArgumentException e) {
                // empty catch block
            }
        }
        try {
            WebElement element = ElementFinder.CONTEXT.findElement(driver, context, createPayload, locator);
            this.finders.put(locator.getClass(), ElementFinder.CONTEXT);
            return element;
        }
        catch (NoSuchElementException e) {
            this.finders.put(locator.getClass(), ElementFinder.CONTEXT);
            throw e;
        }
    }

    public List<WebElement> findElements(RemoteWebDriver driver, SearchContext context, BiFunction<String, Object, CommandPayload> createPayload, By locator) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Context for finding elements", (Object)context);
        Require.nonNull((String)"Method for creating remote requests", createPayload);
        Require.nonNull((String)"Locator", (Object)locator);
        ElementFinder finder = this.finders.get(locator.getClass());
        if (finder != null) {
            return finder.findElements(driver, context, createPayload, locator);
        }
        if (locator instanceof By.Remotable) {
            try {
                List<WebElement> element = ElementFinder.REMOTE.findElements(driver, context, createPayload, locator);
                this.finders.put(locator.getClass(), ElementFinder.REMOTE);
                return element;
            }
            catch (NoSuchElementException e) {
                this.finders.put(locator.getClass(), ElementFinder.REMOTE);
                throw e;
            }
            catch (InvalidArgumentException e) {
                // empty catch block
            }
        }
        List<WebElement> elements = ElementFinder.CONTEXT.findElements(driver, context, createPayload, locator);
        this.finders.put(locator.getClass(), ElementFinder.CONTEXT);
        return elements;
    }

    private static enum ElementFinder {
        CONTEXT{

            @Override
            WebElement findElement(RemoteWebDriver driver, SearchContext context, BiFunction<String, Object, CommandPayload> createPayload, By locator) {
                WebElement element = locator.findElement(context);
                return this.massage(driver, context, element, locator);
            }

            @Override
            List<WebElement> findElements(RemoteWebDriver driver, SearchContext context, BiFunction<String, Object, CommandPayload> createPayload, By locator) {
                List elements = locator.findElements(context);
                return elements.stream().map(e -> this.massage(driver, context, e, locator)).collect(Collectors.toList());
            }
        }
        ,
        REMOTE{

            @Override
            WebElement findElement(RemoteWebDriver driver, SearchContext context, BiFunction<String, Object, CommandPayload> createPayload, By locator) {
                By.Remotable.Parameters params = ((By.Remotable)locator).getRemoteParameters();
                CommandPayload commandPayload = createPayload.apply(params.using(), params.value());
                Response response = driver.execute(commandPayload);
                Object element = response.getValue();
                if (element == null) {
                    throw new NoSuchElementException("Unable to find element with locator " + String.valueOf(locator));
                }
                return this.massage(driver, context, element, locator);
            }

            @Override
            List<WebElement> findElements(RemoteWebDriver driver, SearchContext context, BiFunction<String, Object, CommandPayload> createPayload, By locator) {
                By.Remotable.Parameters params = ((By.Remotable)locator).getRemoteParameters();
                CommandPayload commandPayload = createPayload.apply(params.using(), params.value());
                Response response = driver.execute(commandPayload);
                List elements = (List)response.getValue();
                if (elements == null) {
                    return Collections.emptyList();
                }
                return elements.stream().map(e -> this.massage(driver, context, e, locator)).collect(Collectors.toList());
            }
        };


        abstract WebElement findElement(RemoteWebDriver var1, SearchContext var2, BiFunction<String, Object, CommandPayload> var3, By var4);

        abstract List<WebElement> findElements(RemoteWebDriver var1, SearchContext var2, BiFunction<String, Object, CommandPayload> var3, By var4);

        protected WebElement massage(RemoteWebDriver driver, SearchContext context, Object element, By locator) {
            if (!(element instanceof WebElement)) {
                String hint = element instanceof Map ? ((Map)element).keySet().toString() : (element != null ? element.getClass().getName() : "null");
                throw new WebDriverException("unexpected driver response: " + hint);
            }
            if (!(element instanceof RemoteWebElement)) {
                return (WebElement)element;
            }
            RemoteWebElement remoteElement = (RemoteWebElement)element;
            if (locator instanceof By.Remotable) {
                By.Remotable.Parameters params = ((By.Remotable)locator).getRemoteParameters();
                remoteElement.setFoundBy(context, params.using(), String.valueOf(params.value()));
            }
            remoteElement.setFileDetector(driver.getFileDetector());
            remoteElement.setParent(driver);
            return remoteElement;
        }
    }
}

