/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.AddHasDebugger;
import org.openqa.selenium.safari.AddHasPermissions;
import org.openqa.selenium.safari.HasDebugger;
import org.openqa.selenium.safari.HasPermissions;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;
import org.openqa.selenium.safari.SafariTechPreviewDriverService;

public class SafariDriver
extends RemoteWebDriver
implements HasPermissions,
HasDebugger {
    private final HasPermissions permissions = new AddHasPermissions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasDebugger debugger = new AddHasDebugger().getImplementation(this.getCapabilities(), this.getExecuteMethod());

    public SafariDriver() {
        this(new SafariOptions());
    }

    public SafariDriver(SafariOptions safariOptions) {
        this(safariOptions.getUseTechnologyPreview() ? SafariTechPreviewDriverService.createDefaultService() : SafariDriverService.createDefaultService(), safariOptions);
    }

    public SafariDriver(SafariDriverService safariService) {
        this(safariService, new SafariOptions());
    }

    public SafariDriver(DriverService service, SafariOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public SafariDriver(DriverService service, SafariOptions options, ClientConfig clientConfig) {
        super((CommandExecutor)SafariDriver.generateExecutor(service, options, clientConfig), (Capabilities)options);
    }

    private static SafariDriverCommandExecutor generateExecutor(DriverService service, SafariOptions options, ClientConfig clientConfig) {
        Require.nonNull((String)"Driver service", (Object)service);
        Require.nonNull((String)"Driver options", (Object)((Object)options));
        Require.nonNull((String)"Driver clientConfig", (Object)clientConfig);
        if (service.getExecutable() == null) {
            String path = DriverFinder.getPath((DriverService)service, (Capabilities)options).getDriverPath();
            service.setExecutable(path);
        }
        return new SafariDriverCommandExecutor(service, clientConfig);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf((Capabilities)new SafariOptions(), new Capabilities[0]);
    }

    @Override
    public void setPermissions(String permission, boolean value) {
        Require.nonNull((String)"Permission Name", (Object)permission);
        Require.nonNull((String)"Permission Value", (Object)value);
        this.permissions.setPermissions(permission, value);
    }

    @Override
    public Map<String, Boolean> getPermissions() {
        return this.permissions.getPermissions();
    }

    @Override
    public void attachDebugger() {
        this.debugger.attachDebugger();
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    private static class SafariDriverCommandExecutor
    extends DriverCommandExecutor {
        public SafariDriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
            super(service, SafariDriverCommandExecutor.getExtraCommands(), clientConfig);
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return ImmutableMap.builder().putAll(new AddHasPermissions().getAdditionalCommands()).putAll(new AddHasDebugger().getAdditionalCommands()).build();
        }
    }
}

