/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class SafariDriverService
extends DriverService {
    public static final String SAFARI_DRIVER_EXE_PROPERTY = "webdriver.safari.driver";
    private static final File SAFARI_DRIVER_EXECUTABLE = new File("/usr/bin/safaridriver");

    public SafariDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public SafariDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public static SafariDriverService createDefaultService() {
        return (SafariDriverService)new Builder().build();
    }

    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)((int)this.getTimeout().toMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<SafariDriverService, Builder> {
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.SAFARI.is(capabilities)) {
                ++score;
            }
            return score;
        }

        protected File findDefaultExecutable() {
            File exe = System.getProperty(SafariDriverService.SAFARI_DRIVER_EXE_PROPERTY) != null ? new File(System.getProperty(SafariDriverService.SAFARI_DRIVER_EXE_PROPERTY)) : SAFARI_DRIVER_EXECUTABLE;
            if (!exe.isFile()) {
                StringBuilder message = new StringBuilder();
                message.append("Unable to find driver executable: ").append(exe);
                if (!this.isElCapitanOrLater()) {
                    message.append("(SafariDriver requires Safari 10 running on OSX El Capitan or greater.)");
                }
                throw new WebDriverException(message.toString());
            }
            return exe;
        }

        private boolean isElCapitanOrLater() {
            if (!Platform.getCurrent().is(Platform.MAC)) {
                return false;
            }
            if (Platform.getCurrent().getMajorVersion() > 10) {
                return true;
            }
            return Platform.getCurrent().getMajorVersion() == 10 && Platform.getCurrent().getMinorVersion() >= 11;
        }

        protected List<String> createArgs() {
            return Arrays.asList("--port", String.valueOf(this.getPort()));
        }

        protected SafariDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new SafariDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

