/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    MethodBinding syntheticAccessor;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int Super = 2;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    boolean discardEnclosingInstance;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int accessMode) {
        this.accessMode = accessMode;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)currentScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int i = 0;
                int max = this.arguments.length;
                while (i < max) {
                    flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                    ++i;
                }
            }
            TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
            if (this.binding.thrownExceptions != NoExceptions) {
                flowContext.checkExceptionHandlers(thrownExceptions, this.accessMode == 1 ? (ASTNode)((Object)currentScope.methodScope().referenceContext) : this, flowInfo, currentScope);
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            Object var8_8 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            return flowInfo2;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        try {
            int pc;
            block10: {
                ((MethodScope)currentScope).isConstructorCall = true;
                pc = codeStream.position;
                codeStream.aload_0();
                ReferenceBinding targetType = this.codegenBinding.declaringClass;
                if (targetType.erasure().id == 41 || targetType.isEnum()) {
                    codeStream.aload_1();
                    codeStream.iload_2();
                }
                if (targetType.isNestedType()) {
                    codeStream.generateSyntheticEnclosingInstanceValues(currentScope, targetType, this.discardEnclosingInstance ? null : this.qualification, this);
                }
                this.generateArguments(this.binding, this.arguments, currentScope, codeStream);
                if (targetType.isNestedType()) {
                    codeStream.generateSyntheticOuterArgumentValues(currentScope, targetType, this);
                }
                if (this.syntheticAccessor != null) {
                    int i = 0;
                    int max = this.syntheticAccessor.parameters.length - this.codegenBinding.parameters.length;
                    while (true) {
                        if (i >= max) {
                            codeStream.invokespecial(this.syntheticAccessor);
                            break block10;
                        }
                        codeStream.aconst_null();
                        ++i;
                    }
                }
                codeStream.invokespecial(this.codegenBinding);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            throw throwable;
        }
        {
            Object var8_9 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            return;
        }
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding superTypeErasure = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (!flowInfo.isReachable()) {
            return;
        }
        if (superTypeErasure.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (superTypeErasure.isLocalType()) {
                ((LocalTypeBinding)superTypeErasure).addInnerEmulationDependent(currentScope, this.qualification != null);
            } else {
                currentScope.propagateInnerEmulation(superTypeErasure, this.qualification != null);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.binding.isPrivate() && this.accessMode != 3) {
            if (currentScope.compilerOptions().isPrivateConstructorAccessChangingVisibility) {
                this.codegenBinding.tagForClearingPrivateModifier();
            } else {
                this.syntheticAccessor = ((SourceTypeBinding)this.codegenBinding.declaringClass).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
            }
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ExplicitConstructorCall.printIndent(indent, output);
        if (this.qualification != null) {
            this.qualification.printExpression(0, output).append('.');
        }
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        if (this.accessMode == 3) {
            output.append("this(");
        } else {
            output.append("super(");
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(");");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(BlockScope scope) {
        block29: {
            block28: {
                block26: {
                    block25: {
                        MethodScope methodScope = scope.methodScope();
                        try {
                            boolean argsContainCast;
                            TypeBinding[] argumentTypes;
                            ReferenceBinding receiverType;
                            block27: {
                                AbstractMethodDeclaration methodDeclaration = methodScope.referenceMethod();
                                if (methodDeclaration == null || !methodDeclaration.isConstructor() || ((ConstructorDeclaration)methodDeclaration).constructorCall != this) {
                                    scope.problemReporter().invalidExplicitConstructorCall(this);
                                    Object var12_4 = null;
                                    methodScope.isConstructorCall = false;
                                    return;
                                }
                                methodScope.isConstructorCall = true;
                                receiverType = scope.enclosingSourceType();
                                if (this.accessMode != 3) {
                                    receiverType = receiverType.superclass();
                                }
                                if (receiverType == null) {
                                    break block25;
                                }
                                if (this.accessMode == 2 && receiverType.erasure().id == 41) {
                                    scope.problemReporter().cannotInvokeSuperConstructorInEnum(this, methodScope.referenceMethod().binding);
                                }
                                if (this.qualification != null) {
                                    ReferenceBinding enclosingType;
                                    if (this.accessMode != 2) {
                                        scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                                    }
                                    if ((enclosingType = receiverType.enclosingType()) == null) {
                                        scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                                        this.discardEnclosingInstance = true;
                                    } else {
                                        TypeBinding qTb = this.qualification.resolveTypeExpecting(scope, enclosingType);
                                        this.qualification.computeConversion(scope, qTb, qTb);
                                    }
                                }
                                if (this.typeArguments != null) {
                                    int length = this.typeArguments.length;
                                    boolean argHasError = false;
                                    this.genericTypeArguments = new TypeBinding[length];
                                    int i = 0;
                                    while (true) {
                                        if (i >= length) {
                                            if (!argHasError) break;
                                            break block26;
                                        }
                                        this.genericTypeArguments[i] = this.typeArguments[i].resolveType(scope, true);
                                        if (this.genericTypeArguments[i] == null) {
                                            argHasError = true;
                                        }
                                        ++i;
                                    }
                                }
                                argumentTypes = NoParameters;
                                argsContainCast = false;
                                if (this.arguments != null) {
                                    boolean argHasError = false;
                                    int length = this.arguments.length;
                                    argumentTypes = new TypeBinding[length];
                                    int i = 0;
                                    while (true) {
                                        if (i >= length) {
                                            if (!argHasError) break block27;
                                            break block28;
                                        }
                                        Expression argument = this.arguments[i];
                                        if (argument instanceof CastExpression) {
                                            argument.bits |= 0x20;
                                            argsContainCast = true;
                                        }
                                        if ((argumentTypes[i] = argument.resolveType(scope)) == null) {
                                            argHasError = true;
                                        }
                                        ++i;
                                    }
                                }
                                if (receiverType.erasure().id == 41) {
                                    argumentTypes = new TypeBinding[]{scope.getJavaLangString(), BaseTypes.IntBinding};
                                }
                            }
                            if ((this.binding = scope.getConstructor(receiverType, argumentTypes, this)).isValidBinding()) {
                                if (this.isMethodUseDeprecated(this.binding, scope)) {
                                    scope.problemReporter().deprecatedMethod(this.binding, this);
                                }
                                ExplicitConstructorCall.checkInvocationArguments(scope, null, receiverType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
                                if (this.binding.isPrivate() || receiverType.isLocalType()) {
                                    this.binding.original().modifiers |= 0x8000000;
                                }
                                break block29;
                            }
                            if (this.binding.declaringClass == null) {
                                this.binding.declaringClass = receiverType;
                            }
                            scope.problemReporter().invalidConstructor(this, this.binding);
                            break block29;
                        }
                        catch (Throwable throwable) {
                            Object var12_8 = null;
                            methodScope.isConstructorCall = false;
                            throw throwable;
                        }
                    }
                    Object var12_5 = null;
                    methodScope.isConstructorCall = false;
                    return;
                }
                Object var12_6 = null;
                methodScope.isConstructorCall = false;
                return;
            }
            Object var12_7 = null;
            methodScope.isConstructorCall = false;
            return;
        }
        Object var12_9 = null;
        methodScope.isConstructorCall = false;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
    }

    public void setFieldIndex(int depth) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i;
            if (this.qualification != null) {
                this.qualification.traverse(visitor, scope);
            }
            if (this.typeArguments != null) {
                i = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i < typeArgumentsLength) {
                    this.typeArguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                i = 0;
                int argumentLength = this.arguments.length;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

