/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.rest;

import org.openqa.selenium.remote.server.rest.Renderer;

public class Result {
    private final String mimeType;
    private final Renderer renderer;

    public Result(String mimeType, Renderer renderer) {
        this.mimeType = mimeType;
        this.renderer = renderer;
    }

    public boolean isExactMimeTypeMatch(String contentType) {
        String[] types;
        if (contentType == null) {
            return false;
        }
        for (String type : types = contentType.split("[,;]")) {
            if (!this.mimeType.equals(type)) continue;
            return true;
        }
        return false;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return String.format("Result: %s -> %s", this.mimeType, this.renderer.getClass());
    }
}

