/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.Platform;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.locators.Firefox2or3Locator;

public class FirefoxChromeLauncher
extends AbstractBrowserLauncher {
    private static Log LOGGER = LogFactory.getLog(FirefoxChromeLauncher.class);
    private File customProfileDir = null;
    private String[] cmdarray;
    private boolean closed = false;
    private BrowserInstallation browserInstallation;
    private Process process = null;
    private AsyncExecute shell = new AsyncExecute();
    private boolean changeMaxConnections = false;

    public FirefoxChromeLauncher(BrowserConfigurationOptions browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserString) throws InvalidBrowserExecutableException {
        this(browserOptions, configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("chrome", browserString, new Firefox2or3Locator()));
        if (this.browserInstallation == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
    }

    public FirefoxChromeLauncher(BrowserConfigurationOptions browserOptions, RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration, browserOptions);
        if (browserInstallation == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
        this.browserInstallation = browserInstallation;
        Platform platform = Platform.getCurrent();
        if (!platform.is(Platform.MAC) || platform.is(Platform.MAC) && platform.getMajorVersion() <= 10 && platform.getMinorVersion() <= 5) {
            this.shell.setLibraryPath(browserInstallation.libraryPath());
        }
        this.shell.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
    }

    protected void launch(String url) {
        String profile = "";
        try {
            String homePage = new ChromeUrlConvert().convert(url);
            String profilePath = this.makeCustomProfile(homePage);
            this.populateCustomProfileDirectory(profilePath);
            LOGGER.info((Object)"Launching Firefox...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", profilePath};
            this.shell.setEnvironmentVariable("NO_EM_RESTART", "1");
            this.shell.setCommandline(this.cmdarray);
            this.process = this.shell.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateCustomProfileDirectory(String profilePath) throws IOException {
        this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", profilePath, "-silent"};
        LOGGER.info((Object)"Preparing Firefox profile...");
        this.shell.setCommandline(this.cmdarray);
        this.shell.execute();
        this.waitForFullProfileToBeCreated(20000L);
    }

    protected void createCustomProfileDir() {
        this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
    }

    protected void copyDirectory(File sourceDir, File destDir) {
        LauncherUtils.copyDirectory(sourceDir, destDir);
    }

    protected File initProfileTemplate() {
        File profilesLocation;
        File firefoxProfileTemplate = null;
        String relativeProfile = this.browserConfigurationOptions.getProfile();
        if (relativeProfile == null) {
            relativeProfile = "";
        }
        if ((profilesLocation = this.getConfiguration().getProfilesLocation()) != null && !"".equals(relativeProfile)) {
            firefoxProfileTemplate = this.getFileFromParent(profilesLocation, relativeProfile);
            if (!firefoxProfileTemplate.exists()) {
                throw new RuntimeException("The profile specified '" + firefoxProfileTemplate.getAbsolutePath() + "' does not exist");
            }
        } else {
            firefoxProfileTemplate = this.browserConfigurationOptions.getFile("firefoxProfileTemplate");
        }
        if (firefoxProfileTemplate != null) {
            this.copyDirectory(firefoxProfileTemplate, this.customProfileDir);
        }
        return firefoxProfileTemplate;
    }

    protected void extractProfileFromJar() throws IOException {
        ResourceExtractor.extractResourcePath(this.getClass(), "/customProfileDirCUSTFFCHROME", this.customProfileDir);
    }

    protected void copySingleFileWithOverwrite(File sourceFile, File destFile) {
        LauncherUtils.copySingleFileWithOverwrite(sourceFile, destFile, true);
    }

    protected File getFileFromParent(File parent, String child) {
        return new File(parent, child);
    }

    protected void copyCert8db(File firefoxProfileTemplate) {
        File sourceCertFile;
        if (firefoxProfileTemplate != null && (sourceCertFile = this.getFileFromParent(firefoxProfileTemplate, "cert8.db")).exists()) {
            File destCertFile = new File(this.customProfileDir, "cert8.db");
            this.copySingleFileWithOverwrite(sourceCertFile, destCertFile);
        }
    }

    protected void generatePacAndPrefJs(String homePage) throws IOException {
        LauncherUtils.ProxySetting proxySetting = LauncherUtils.ProxySetting.NO_PROXY;
        if (this.browserConfigurationOptions.is("captureNetworkTraffic") || this.browserConfigurationOptions.is("addCustomRequestHeaders")) {
            proxySetting = LauncherUtils.ProxySetting.PROXY_EVERYTHING;
        }
        LauncherUtils.generatePacAndPrefJs(this.customProfileDir, this.getPort(), proxySetting, homePage, this.changeMaxConnections, this.getTimeout(), this.browserConfigurationOptions.is("avoidProxy"));
    }

    private String makeCustomProfile(String homePage) throws IOException {
        this.createCustomProfileDir();
        File firefoxProfileTemplate = this.initProfileTemplate();
        this.extractProfileFromJar();
        this.copyCert8db(firefoxProfileTemplate);
        this.copyRunnerHtmlFiles();
        this.changeMaxConnections = this.browserConfigurationOptions.is("changeMaxConnections");
        this.generatePacAndPrefJs(homePage);
        return this.customProfileDir.getAbsolutePath();
    }

    private void copyRunnerHtmlFiles() {
        String guid = "{503A0CD4-EDC8-489b-853B-19E0BAA8F0A4}";
        File extensionDir = new File(this.customProfileDir, "extensions/" + guid);
        File htmlDir = new File(extensionDir, "chrome");
        htmlDir.mkdirs();
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/TestRunner.html", "TestRunner.html");
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/TestPrompt.html", "TestPrompt.html");
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/RemoteRunner.html", "RemoteRunner.html");
    }

    public void close() {
        if (this.closed) {
            return;
        }
        FileLockRemainedException fileLockException = null;
        if (this.process != null) {
            try {
                this.killFirefoxProcess();
            }
            catch (FileLockRemainedException flre) {
                fileLockException = flre;
            }
        }
        if (this.customProfileDir != null) {
            try {
                this.removeCustomProfileDir();
            }
            catch (RuntimeException e) {
                if (fileLockException != null) {
                    LOGGER.error((Object)"Couldn't delete custom Firefox profile directory", (Throwable)e);
                    LOGGER.error((Object)"Perhaps caused by this exception:");
                    if (fileLockException != null) {
                        LOGGER.error((Object)"Perhaps caused by this exception:", (Throwable)fileLockException);
                    }
                    throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see error LOGGER!", e);
                }
                throw e;
            }
        }
        this.closed = true;
    }

    protected void removeCustomProfileDir() throws RuntimeException {
        LauncherUtils.deleteTryTryAgain(this.customProfileDir, 6);
    }

    protected void killFirefoxProcess() throws FileLockRemainedException {
        LOGGER.info((Object)"Killing Firefox...");
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            LOGGER.warn((Object)"Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        this.waitForFileLockToGoAway(0L, 500L);
    }

    public Process getProcess() {
        return this.process;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir, "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    protected void setCustomProfileDir(File value) {
        this.customProfileDir = value;
    }

    protected void setProcess(Process p) {
        this.process = p;
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        if (suiteUrl != null && suiteUrl.startsWith("TestPrompt.html?")) {
            suiteUrl = suiteUrl.replaceFirst("^TestPrompt\\.html\\?", "chrome://src/content/TestPrompt.html?");
        }
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl, !this.browserConfigurationOptions.isSingleWindow(), this.getPort()));
    }

    public void launchRemoteSession(String browserURL) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId, !this.browserConfigurationOptions.isSingleWindow(), this.getPort(), this.browserConfigurationOptions.is("browserSideLog")));
    }

    public static class ChromeUrlConvert {
        public String convert(String httpUrl) throws MalformedURLException {
            String query = LauncherUtils.getQueryString(httpUrl);
            String file = new File(new URL(httpUrl).getPath()).getName();
            return "chrome://src/content/" + file + "?" + query;
        }
    }

    protected class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

