/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.server.IOHelper;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.commands.CaptureScreenshotToStringCommand;
import org.openqa.selenium.server.commands.Command;
import org.openqa.selenium.server.commands.SeleniumCoreCommand;

public class CaptureEntirePageScreenshotToStringCommand
extends Command {
    public static final String ID = "captureEntirePageScreenshotToString";
    private static final Log LOGGER = LogFactory.getLog(CaptureScreenshotToStringCommand.class);
    private final String kwargs;
    private final String sessionId;

    public CaptureEntirePageScreenshotToStringCommand(String kwargs, String sessionId) {
        this.kwargs = kwargs;
        this.sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        String string;
        InputStream inputStream = null;
        String filePath = this.screenshotFilePath();
        LOGGER.debug((Object)("Capturing page screenshot for session " + this.sessionId + " under '" + filePath + "'"));
        this.capturePageScreenshot(filePath);
        try {
            byte[] encodedData = Base64.encodeBase64((byte[])IOHelper.readFile(filePath));
            string = "OK," + new String(encodedData);
            Object var7_6 = null;
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = "ERROR: " + e;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                IOHelper.close(inputStream);
                throw throwable;
            }
            IOHelper.close(inputStream);
            return string2;
        }
        IOHelper.close(inputStream);
        return string;
    }

    public String capturePageScreenshot(String filePath) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(filePath);
        args.add(this.kwargs);
        SeleniumCoreCommand pageScreenshotCommand = new SeleniumCoreCommand("captureEntirePageScreenshot", args, this.sessionId);
        pageScreenshotCommand.execute();
        return null;
    }

    public String screenshotFilePath() {
        File screenshotDir = this.screenshotDirectory();
        return screenshotDir + "/page-screenshot-" + this.sessionId + ".png";
    }

    public File screenshotDirectory() {
        File screenshotDir = new File(LauncherUtils.customProfileDir(this.sessionId), "screenshots");
        if (!screenshotDir.exists()) {
            screenshotDir.mkdirs();
        }
        return screenshotDir;
    }
}

