/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.html5;

import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.html5.Utils;
import org.openqa.selenium.remote.server.rest.ResultType;

public class SetLocationContext
extends WebDriverHandler
implements JsonParametersAware {
    private volatile Location location;

    public SetLocationContext(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        Utils.getLocationContext(this.getUnwrappedDriver()).setLocation(this.location);
        return ResultType.SUCCESS;
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        double altitude;
        double longitude;
        double latitude;
        Map map = (Map)allParameters.get("location");
        try {
            latitude = ((Number)allParameters.get("latitude")).doubleValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-double) latitude location passed: " + allParameters.get("latitude"), (Throwable)ex);
        }
        try {
            longitude = ((Number)allParameters.get("longitude")).doubleValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-double) longitude location passed: " + allParameters.get("longitude"), (Throwable)ex);
        }
        try {
            altitude = ((Number)allParameters.get("altitude")).doubleValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-double) altitude location passed: " + allParameters.get("altitude"), (Throwable)ex);
        }
        this.location = new Location(latitude, longitude, altitude);
    }

    public String toString() {
        return String.format("[set location context: %s]", this.location.toString());
    }
}

