/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;

public class TestCase {
    private static Log log = LogFactory.getLog(TestCase.class);
    private static Vector tests = new Vector();
    private static final String fail = "FAIL";
    private static final char[] spaces = "                                                                                 ".toCharArray();
    static final String SelfFailTest = "org.openqa.jetty.util.TestCase all fail";
    private String testCase;
    private StringBuffer reportBuf = new StringBuffer(512);
    private boolean passed = true;

    public TestCase(String testCase) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed test case: " + testCase));
        }
        this.testCase = testCase;
        tests.addElement(this);
    }

    public void check(boolean b, String check) {
        if (!b) {
            this.reportBuf.append(this.testCase + " : " + check + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append("check!=true");
            if (log.isDebugEnabled()) {
                log.debug((Object)(check + " FAILED"));
            }
        }
        this.reportBuf.append('\n');
    }

    public int checkContains(String string, String subString, String check) {
        return this.realCheckContains(string, 0, subString, check);
    }

    public int checkContains(String string, int offset, String subString, String check) {
        return this.realCheckContains(string, offset, subString, check);
    }

    public int realCheckContains(String string, int offset, String subString, String check) {
        int index = -1;
        if ((string != null || subString != null) && (string == null || subString != null && (index = string.indexOf(subString, offset)) < 0)) {
            this.reportBuf.append(this.testCase + " : " + check + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append('\"' + subString + "\" not contained in \"");
            if (offset < string.length()) {
                this.reportBuf.append(string.substring(offset));
            } else {
                this.reportBuf.append("string<offset:" + offset + ":'" + string + "'");
            }
            this.reportBuf.append("\"");
            if (log.isDebugEnabled()) {
                log.debug((Object)(check + " FAILED: " + this.reportBuf.toString()));
            }
            this.reportBuf.append('\n');
        }
        return index;
    }

    public int checkNotContained(String string, String subString, String check) {
        return this.checkNotContained(string, 0, subString, check);
    }

    public int checkNotContained(String string, int offset, String subString, String check) {
        int index = -1;
        if (string == null && subString == null || string != null && (subString == null || (index = string.indexOf(subString, offset)) >= 0)) {
            this.reportBuf.append(this.testCase + " : " + check + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append('\"' + subString + "\" IS contained in \"" + string.substring(offset) + '\"');
            if (log.isDebugEnabled()) {
                log.debug((Object)(check + " FAILED"));
            }
            this.reportBuf.append('\n');
        }
        return index;
    }

    public void checkEquals(Object o1, Object o2, String check) {
        this.commonCheckEquals(o1, o2, check);
    }

    public void checkEquals(long l1, long l2, String check) {
        this.commonCheckEquals(new Long(l1), new Long(l2), check);
    }

    public void checkEquals(double d1, double d2, String check) {
        this.commonCheckEquals(new Double(d1), new Double(d2), check);
    }

    public void checkEquals(char c1, char c2, String check) {
        this.commonCheckEquals(new Character(c1), new Character(c2), check);
    }

    public void checkEquals(InputStream in1, InputStream in2, String check) {
        try {
            int c2;
            int c1;
            while ((c1 = in1.read()) == (c2 = in2.read())) {
                if (c1 != -1) continue;
                this.commonCheckEquals(null, null, check);
                return;
            }
            this.commonCheckEquals("" + c1, "" + c2, check);
        }
        catch (Exception e) {
            this.commonCheckEquals(e.toString(), null, check);
        }
    }

    private void commonCheckEquals(Object o1, Object o2, String check) {
        if (!(o1 == o2 || o1 != null && o1.equals(o2))) {
            this.reportBuf.append(this.testCase + " : " + check + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append((o1 != null ? o1.toString() : "null") + " != " + (o2 != null ? o2.toString() : "null"));
            if (log.isDebugEnabled()) {
                log.debug((Object)(3 + check + " FAILED"));
            }
            this.reportBuf.append('\n');
        }
    }

    public static void report() {
        Enumeration e = tests.elements();
        while (e.hasMoreElements()) {
            TestCase t = (TestCase)e.nextElement();
            if (t.passed) continue;
            System.err.print("\nTest Case: " + t.testCase);
            System.err.println("  - FAILED");
            System.err.println(t.reportBuf.toString());
        }
        System.err.println("\nTEST SUMMARY:");
        e = tests.elements();
        boolean failed = false;
        while (e.hasMoreElements()) {
            TestCase t = (TestCase)e.nextElement();
            if (t.passed || t.testCase.equals(SelfFailTest)) continue;
            System.err.print("Test Case: " + t.testCase);
            System.err.println("  - FAILED");
            failed = true;
        }
        if (failed) {
            System.exit(1);
        }
        System.exit(0);
    }
}

