/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.beust.jcommander.JCommander;
import javax.servlet.Servlet;
import org.openqa.selenium.remote.server.CommandLineArgs;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverServlet;
import org.seleniumhq.jetty9.server.ConnectionFactory;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.Handler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;
import org.seleniumhq.jetty9.util.thread.ThreadPool;

public class SeleniumServer {
    private final int port;
    private int threadCount;
    private Server server;

    public SeleniumServer(int port) {
        this.port = port;
    }

    private void addRcSupport(ServletContextHandler handler) {
        try {
            Class<Servlet> rcServlet = Class.forName("com.thoughtworks.selenium.webdriven.WebDriverBackedSeleniumServlet", false, this.getClass().getClassLoader()).asSubclass(Servlet.class);
            handler.addServlet(rcServlet, "/selenium-server/driver/");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void start() {
        this.server = this.threadCount > 0 ? new Server((ThreadPool)new QueuedThreadPool(this.threadCount)) : new Server();
        ServletContextHandler handler = new ServletContextHandler();
        DefaultDriverSessions webdriverSessions = new DefaultDriverSessions();
        handler.setAttribute(DriverServlet.SESSIONS_KEY, (Object)webdriverSessions);
        handler.setContextPath("/");
        handler.addServlet(DriverServlet.class, "/wd/hub/*");
        this.addRcSupport(handler);
        this.server.setHandler((Handler)handler);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        http.setPort(this.port);
        http.setIdleTimeout(500000L);
        this.server.setConnectors(new Connector[]{http});
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] argv) {
        CommandLineArgs args = new CommandLineArgs();
        JCommander jCommander = new JCommander((Object)args, argv);
        jCommander.setProgramName("selenium-3-server");
        if (args.help) {
            StringBuilder message = new StringBuilder();
            jCommander.usage(message);
            System.err.println(message.toString());
            return;
        }
        SeleniumServer server = new SeleniumServer(args.port);
        server.setThreadCount(args.jettyThreads);
        server.start();
    }
}

