/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;

public class GridConfiguration
extends StandaloneConfiguration {
    @Expose
    public Integer cleanUpCycle;
    @Expose
    public Map<String, String> custom = new HashMap<String, String>();
    @Expose
    public Integer maxSession;
    @Expose
    public List<String> servlets = new ArrayList<String>();
    @Expose
    public List<String> withoutServlets = new ArrayList<String>();

    GridConfiguration() {
    }

    public void merge(GridConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(Integer.class, other.cleanUpCycle, this.cleanUpCycle)) {
            this.cleanUpCycle = other.cleanUpCycle;
        }
        if (this.isMergeAble(Map.class, other.custom, this.custom)) {
            if (this.custom == null) {
                this.custom = new HashMap<String, String>();
            }
            this.custom.putAll(other.custom);
        }
        if (this.isMergeAble(Integer.class, other.maxSession, this.maxSession) && other.maxSession > 0) {
            this.maxSession = other.maxSession;
        }
        if (this.isMergeAble(List.class, other.servlets, this.servlets)) {
            this.servlets = other.servlets;
        }
        if (this.isMergeAble(List.class, other.withoutServlets, this.withoutServlets)) {
            this.withoutServlets = other.withoutServlets;
        }
    }

    public boolean isWithOutServlet(Class<? extends Servlet> servlet) {
        return this.withoutServlets != null && servlet != null && this.withoutServlets.contains(servlet.getCanonicalName());
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "cleanUpCycle", this.cleanUpCycle));
        sb.append((CharSequence)this.toString(format, "custom", this.custom));
        sb.append((CharSequence)this.toString(format, "maxSession", this.maxSession));
        sb.append((CharSequence)this.toString(format, "servlets", this.servlets));
        sb.append((CharSequence)this.toString(format, "withoutServlets", this.withoutServlets));
        return sb.toString();
    }
}

