/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.RemoteSession;
import org.openqa.selenium.remote.server.SessionCodec;
import org.openqa.selenium.remote.server.jmx.JMXHelper;
import org.openqa.selenium.remote.server.jmx.ManagedService;
import org.openqa.selenium.remote.service.DriverService;

@ManagedService
public class ServicedSession
extends RemoteSession {
    private final DriverService service;

    public ServicedSession(DriverService service, Dialect downstream, Dialect upstream, SessionCodec codec, SessionId id, Map<String, Object> capabilities) {
        super(downstream, upstream, codec, id, capabilities);
        this.service = service;
        new JMXHelper().register(this);
    }

    public String toString() {
        return this.getId().toString() + " (" + this.service.getClass().getName() + ")";
    }

    @Override
    public void stop() {
        try {
            HttpRequest request = new HttpRequest(HttpMethod.DELETE, "/session/" + this.getId());
            HttpResponse ignored = new HttpResponse();
            this.execute(request, ignored);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.service.stop();
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(String.format("org.seleniumhq.server:type=Session,browser=\"%s\",id=%s", this.getCapabilities().get("browserName"), this.getId()));
    }

    public static class Factory
    extends RemoteSession.Factory<DriverService> {
        private final Predicate<Capabilities> key;
        private final Function<Capabilities, ? extends DriverService> createService;
        private final String serviceClassName;

        public Factory(Predicate<Capabilities> key, String serviceClassName) {
            this.key = key;
            this.serviceClassName = serviceClassName;
            try {
                Class<DriverService> driverClazz = Class.forName(serviceClassName).asSubclass(DriverService.class);
                Function<Capabilities, ? extends DriverService> factory = this.get(driverClazz, Capabilities.class);
                if (factory == null) {
                    factory = this.get(driverClazz, new Class[0]);
                }
                if (factory == null) {
                    throw new IllegalArgumentException("DriverService has no mechansim to create a default instance");
                }
                this.createService = factory;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("DriverService class does not exist: " + serviceClassName);
            }
        }

        private Function<Capabilities, ? extends DriverService> get(Class<? extends DriverService> driverServiceClazz, Class ... args) {
            try {
                Method serviceMethod = driverServiceClazz.getDeclaredMethod("createDefaultService", args);
                serviceMethod.setAccessible(true);
                return caps -> {
                    try {
                        if (args.length > 0) {
                            return (DriverService)serviceMethod.invoke(null, caps);
                        }
                        return (DriverService)serviceMethod.invoke(null, new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new SessionNotCreatedException("Unable to create new service: " + driverServiceClazz.getSimpleName(), (Throwable)e);
                    }
                };
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }

        @Override
        public boolean isSupporting(Capabilities capabilities) {
            return this.key.test(capabilities);
        }

        @Override
        public Optional<ActiveSession> apply(Set<Dialect> downstreamDialects, Capabilities capabilities) {
            DriverService service = this.createService.apply(capabilities);
            try {
                service.start();
                PortProber.waitForPortUp((int)service.getUrl().getPort(), (int)30, (TimeUnit)TimeUnit.SECONDS);
                URL url = service.getUrl();
                return this.performHandshake(service, url, downstreamDialects, capabilities);
            }
            catch (IOException | IllegalStateException | NullPointerException e) {
                RemoteSession.log.log(Level.WARNING, e.getMessage(), e);
                service.stop();
                return Optional.empty();
            }
        }

        protected ServicedSession newActiveSession(DriverService service, Dialect downstream, Dialect upstream, SessionCodec codec, SessionId id, Map<String, Object> capabilities) {
            return new ServicedSession(service, downstream, upstream, codec, id, capabilities);
        }

        public String toString() {
            return this.getClass().getName() + " (provider: " + this.serviceClassName + ")";
        }
    }
}

