/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.CommandHandler;

public class NoHandler
implements CommandHandler {
    private final Json json;

    public NoHandler(Json json) {
        this.json = Objects.requireNonNull(json);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Map<String, Integer> responseMap = new HashMap<String, Integer>();
        responseMap.put("sessionId", null);
        responseMap.put("status", 9);
        responseMap.put("value", (Integer)ImmutableMap.of((Object)"error", (Object)"unknown command", (Object)"message", (Object)String.format("Unable to find command matching %s to %s", req.getMethod(), req.getUri()), (Object)"stacktrace", (Object)""));
        responseMap = Collections.unmodifiableMap(responseMap);
        byte[] payload = this.json.toJson(responseMap).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(404);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

