/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.BySelector;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public abstract class WebDriverHandler<T>
implements RestishHandler<T>,
Callable<T> {
    private final Session session;

    protected WebDriverHandler(Session session) {
        this.session = session;
    }

    @Override
    public final T handle() throws Exception {
        return (T)this.call();
    }

    public SessionId getSessionId() {
        return this.session.getSessionId();
    }

    public String getScreenshot() {
        Session session = this.getSession();
        return session != null ? session.getAndClearScreenshot() : null;
    }

    protected WebDriver getDriver() {
        Session session = this.getSession();
        return session.getDriver();
    }

    protected Session getSession() {
        return this.session;
    }

    protected KnownElements getKnownElements() {
        return this.getSession().getKnownElements();
    }

    protected BySelector newBySelector() {
        return new BySelector();
    }

    protected WebDriver getUnwrappedDriver() {
        WebDriver toReturn = this.getDriver();
        while (toReturn instanceof WrapsDriver) {
            toReturn = ((WrapsDriver)toReturn).getWrappedDriver();
        }
        return (WebDriver)Preconditions.checkNotNull((Object)toReturn);
    }
}

