/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.selenium.remote.DesiredCapabilities;

@ThreadSafe
public class NewSessionRequestQueue {
    private static final Logger log = Logger.getLogger(NewSessionRequestQueue.class.getName());
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final List<RequestHandler> newSessionRequests = new ArrayList<RequestHandler>();

    public void add(RequestHandler request) {
        this.lock.writeLock().lock();
        try {
            this.newSessionRequests.add(request);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue(Predicate<RequestHandler> handlerConsumer, Prioritizer prioritizer) {
        Comparator comparator = prioritizer == null ? (arg_0, arg_1) -> ((Ordering)Ordering.allEqual()).compare(arg_0, arg_1) : (a, b) -> prioritizer.compareTo(a.getRequest().getDesiredCapabilities(), b.getRequest().getDesiredCapabilities());
        this.lock.writeLock().lock();
        try {
            this.newSessionRequests.stream().sorted(comparator).filter(handlerConsumer).forEach(requestHandler -> {
                if (!this.removeNewSessionRequest((RequestHandler)requestHandler)) {
                    log.severe("Bug removing request " + requestHandler);
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clearNewSessionRequests() {
        this.lock.writeLock().lock();
        try {
            this.newSessionRequests.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeNewSessionRequest(RequestHandler request) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.newSessionRequests.remove(request);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Iterable<DesiredCapabilities> getDesiredCapabilities() {
        this.lock.readLock().lock();
        try {
            Iterable iterable = this.newSessionRequests.stream().map(req -> new DesiredCapabilities(req.getRequest().getDesiredCapabilities())).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getNewSessionRequestCount() {
        this.lock.readLock().lock();
        try {
            int n = this.newSessionRequests.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void stop() {
        this.lock.writeLock().lock();
        try {
            this.newSessionRequests.forEach(RequestHandler::stop);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

