/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class W3CCommandHandler
implements CommandHandler {
    public static final Json JSON = new Json();
    private final ErrorCodes errors = new ErrorCodes();
    private final CommandHandler delegate;

    public W3CCommandHandler(CommandHandler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Cache-Control", "none");
        try {
            this.delegate.execute(req, resp);
        }
        catch (Throwable cause) {
            resp.setStatus(this.errors.getHttpStatusCode(cause));
            resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
            resp.setHeader("Cache-Control", "none");
            resp.setContent(JSON.toJson((Object)ImmutableMap.of((Object)"status", (Object)this.errors.toStatusCode(cause), (Object)"value", (Object)cause)).getBytes(StandardCharsets.UTF_8));
        }
    }
}

