/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.StyledElement;
import java.awt.Dimension;
import java.awt.Point;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;

public class RenderedHtmlUnitDriverWebElement
extends HtmlUnitWebElement
implements RenderedWebElement {
    public RenderedHtmlUnitDriverWebElement(HtmlUnitDriver parent, HtmlElement element) {
        super(parent, element);
    }

    public void sendKeys(CharSequence ... value) {
        this.assertElementNotStale();
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You may only sendKeys to visible elements");
        }
        super.sendKeys(value);
    }

    public boolean toggle() {
        this.assertElementNotStale();
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You may only toggle visible elements");
        }
        return super.toggle();
    }

    public void click() {
        this.assertElementNotStale();
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You may only click visible elements");
        }
        super.click();
    }

    public void setSelected() {
        this.assertElementNotStale();
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You may only select visible elements");
        }
        super.setSelected();
    }

    public boolean isDisplayed() {
        this.assertElementNotStale();
        return !(this.element instanceof HtmlHiddenInput) && this.element.isDisplayed();
    }

    public void hover() {
        throw new UnsupportedOperationException("Hover is not supported by the htmlunit driver");
    }

    public Point getLocation() {
        this.assertElementNotStale();
        String script = "var e = arguments[0]; if (e.getBoundingClientRect instanceof Function) {var r = e.getBoundingClientRect();return r.left + ',' + r.top;} return undefined;";
        String result = (String)this.parent.executeScript(script, this.element);
        if (result == null) {
            result = (String)this.parent.executeScript("var w = arguments[0].offsetLeft; var h = arguments[0].offsetTop; return w + ',' + h;", this.element);
        }
        try {
            String[] sizes = result.split(",", 2);
            return new Point(Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1]));
        }
        catch (Exception e) {
            throw new WebDriverException("Cannot determine size of element from: " + result);
        }
    }

    public Dimension getSize() {
        this.assertElementNotStale();
        String script = "var e = arguments[0]; if (e.getBoundingClientRect instanceof Function) {var r = e.getBoundingClientRect();var w = r.left - r.right; var h = r.top - r.bottom;return w + ',' + h;} return undefined;";
        String result = (String)this.parent.executeScript(script, this.element);
        if (result == null) {
            result = (String)this.parent.executeScript("var w = arguments[0].scrollWidth; var h = arguments[0].scrollHeight; return w + ',' + h;", this.element);
        }
        try {
            String[] sizes = result.split(",", 2);
            return new Dimension(Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1]));
        }
        catch (Exception e) {
            throw new WebDriverException("Cannot determine size of element from: " + result);
        }
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        this.assertElementNotStale();
        throw new UnsupportedOperationException("dragAndDropBy");
    }

    public void dragAndDropOn(RenderedWebElement element) {
        this.assertElementNotStale();
        throw new UnsupportedOperationException("dragAndDropOn");
    }

    public String getValueOfCssProperty(String propertyName) {
        this.assertElementNotStale();
        return this.getEffectiveStyle(this.element, propertyName);
    }

    private String getEffectiveStyle(HtmlElement htmlElement, String propertyName) {
        if (!(htmlElement instanceof StyledElement)) {
            return "";
        }
        HtmlElement current = htmlElement;
        String value = "inherit";
        while (current instanceof StyledElement && "inherit".equals(value)) {
            Object result = this.parent.executeScript("if (window.getComputedStyle) {     return window.getComputedStyle(arguments[0], null)[arguments[1]]; } if (arguments[0].currentStyle) {     return arguments[0].currentStyle[arguments[1]]; } if (window.document.defaultView && window.document.defaultView.getComputedStyle) {     return window.document.defaultView.getComputedStyle(arguments[0], null)[arguments[1]]; } ", current, propertyName);
            if (!(result instanceof Undefined)) {
                value = String.valueOf(result);
            }
            current = (HtmlElement)current.getParentNode();
        }
        return value;
    }
}

