/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;

public class HttpCommandExecutor
implements CommandExecutor {
    private final String remotePath;
    private Map<String, CommandInfo> nameToUrl = new HashMap<String, CommandInfo>();
    private HttpClient client;

    public HttpCommandExecutor(URL addressOfRemoteServer) throws Exception {
        if (addressOfRemoteServer == null) {
            String remoteServer = System.getProperty("webdriver.remote.server");
            URL uRL = addressOfRemoteServer = remoteServer == null ? null : new URL(remoteServer);
            if (addressOfRemoteServer == null) {
                throw new IllegalArgumentException("You must specify a remote address to connect to");
            }
        }
        this.remotePath = addressOfRemoteServer.getPath();
        URI uri = new URI(addressOfRemoteServer.toString(), false);
        this.client = new HttpClient();
        this.client.getHostConfiguration().setHost(uri);
        this.nameToUrl.put("newSession", new CommandInfo("/session", HttpVerb.POST));
        this.nameToUrl.put("quit", new CommandInfo("/session/:sessionId", HttpVerb.DELETE));
        this.nameToUrl.put("getCurrentWindowHandle", new CommandInfo("/session/:sessionId/:context/window_handle", HttpVerb.GET));
        this.nameToUrl.put("getWindowHandles", new CommandInfo("/session/:sessionId/:context/window_handles", HttpVerb.GET));
        this.nameToUrl.put("get", new CommandInfo("/session/:sessionId/:context/url", HttpVerb.POST));
        this.nameToUrl.put("forward", new CommandInfo("/session/:sessionId/:context/forward", HttpVerb.POST));
        this.nameToUrl.put("back", new CommandInfo("/session/:sessionId/:context/back", HttpVerb.POST));
        this.nameToUrl.put("refresh", new CommandInfo("/session/:sessionId/:context/refresh", HttpVerb.POST));
        this.nameToUrl.put("executeScript", new CommandInfo("/session/:sessionId/:context/execute", HttpVerb.POST));
        this.nameToUrl.put("currentUrl", new CommandInfo("/session/:sessionId/:context/url", HttpVerb.GET));
        this.nameToUrl.put("getTitle", new CommandInfo("/session/:sessionId/:context/title", HttpVerb.GET));
        this.nameToUrl.put("pageSource", new CommandInfo("/session/:sessionId/:context/source", HttpVerb.GET));
        this.nameToUrl.put("screenshot", new CommandInfo("/session/:sessionId/:context/screenshot", HttpVerb.GET));
        this.nameToUrl.put("setVisible", new CommandInfo("/session/:sessionId/:context/visible", HttpVerb.POST));
        this.nameToUrl.put("getVisible", new CommandInfo("/session/:sessionId/:context/visible", HttpVerb.GET));
        this.nameToUrl.put("findElement", new CommandInfo("/session/:sessionId/:context/element", HttpVerb.POST));
        this.nameToUrl.put("findElements", new CommandInfo("/session/:sessionId/:context/elements", HttpVerb.POST));
        this.nameToUrl.put("getActiveElement", new CommandInfo("/session/:sessionId/:context/element/active", HttpVerb.POST));
        this.nameToUrl.put("findElementUsingElement", new CommandInfo("/session/:sessionId/:context/element/:id/element/:using", HttpVerb.POST));
        this.nameToUrl.put("findElementsUsingElement", new CommandInfo("/session/:sessionId/:context/element/:id/elements/:using", HttpVerb.POST));
        this.nameToUrl.put("clickElement", new CommandInfo("/session/:sessionId/:context/element/:id/click", HttpVerb.POST));
        this.nameToUrl.put("clearElement", new CommandInfo("/session/:sessionId/:context/element/:id/clear", HttpVerb.POST));
        this.nameToUrl.put("submitElement", new CommandInfo("/session/:sessionId/:context/element/:id/submit", HttpVerb.POST));
        this.nameToUrl.put("getElementText", new CommandInfo("/session/:sessionId/:context/element/:id/text", HttpVerb.GET));
        this.nameToUrl.put("sendKeys", new CommandInfo("/session/:sessionId/:context/element/:id/value", HttpVerb.POST));
        this.nameToUrl.put("getElementValue", new CommandInfo("/session/:sessionId/:context/element/:id/value", HttpVerb.GET));
        this.nameToUrl.put("getTagName", new CommandInfo("/session/:sessionId/:context/element/:id/name", HttpVerb.GET));
        this.nameToUrl.put("isElementSelected", new CommandInfo("/session/:sessionId/:context/element/:id/selected", HttpVerb.GET));
        this.nameToUrl.put("setElementSelected", new CommandInfo("/session/:sessionId/:context/element/:id/selected", HttpVerb.POST));
        this.nameToUrl.put("toggleElement", new CommandInfo("/session/:sessionId/:context/element/:id/toggle", HttpVerb.POST));
        this.nameToUrl.put("isElementEnabled", new CommandInfo("/session/:sessionId/:context/element/:id/enabled", HttpVerb.GET));
        this.nameToUrl.put("isElementDisplayed", new CommandInfo("/session/:sessionId/:context/element/:id/displayed", HttpVerb.GET));
        this.nameToUrl.put("hover", new CommandInfo("/session/:sessionId/:context/element/:id/hover", HttpVerb.POST));
        this.nameToUrl.put("getElementLocation", new CommandInfo("/session/:sessionId/:context/element/:id/location", HttpVerb.GET));
        this.nameToUrl.put("getElementSize", new CommandInfo("/session/:sessionId/:context/element/:id/size", HttpVerb.GET));
        this.nameToUrl.put("getElementAttribute", new CommandInfo("/session/:sessionId/:context/element/:id/attribute/:name", HttpVerb.GET));
        this.nameToUrl.put("equals", new CommandInfo("/session/:sessionId/:context/element/:id/equals/:other", HttpVerb.GET));
        this.nameToUrl.put("getAllCookies", new CommandInfo("/session/:sessionId/:context/cookie", HttpVerb.GET));
        this.nameToUrl.put("addCookie", new CommandInfo("/session/:sessionId/:context/cookie", HttpVerb.POST));
        this.nameToUrl.put("deleteAllCookies", new CommandInfo("/session/:sessionId/:context/cookie", HttpVerb.DELETE));
        this.nameToUrl.put("deleteCookie", new CommandInfo("/session/:sessionId/:context/cookie/:name", HttpVerb.DELETE));
        this.nameToUrl.put("switchToFrame", new CommandInfo("/session/:sessionId/:context/frame/:id", HttpVerb.POST));
        this.nameToUrl.put("switchToWindow", new CommandInfo("/session/:sessionId/:context/window/:name", HttpVerb.POST));
        this.nameToUrl.put("close", new CommandInfo("/session/:sessionId/:context/window", HttpVerb.DELETE));
        this.nameToUrl.put("dragElement", new CommandInfo("/session/:sessionId/:context/element/:id/drag", HttpVerb.POST));
        this.nameToUrl.put("getSpeed", new CommandInfo("/session/:sessionId/:context/speed", HttpVerb.GET));
        this.nameToUrl.put("setSpeed", new CommandInfo("/session/:sessionId/:context/speed", HttpVerb.POST));
        this.nameToUrl.put("getValueOfCssProperty", new CommandInfo("/session/:sessionId/:context/element/:id/css/:propertyName", HttpVerb.GET));
    }

    public Response execute(Command command) throws Exception {
        CommandInfo info = this.nameToUrl.get(command.getMethodName());
        HttpMethod httpMethod = info.getMethod(this.remotePath, command);
        httpMethod.addRequestHeader("Accept", "application/json, image/png");
        String payload = new BeanToJsonConverter().convert((Object)command.getParameters());
        if (httpMethod instanceof PostMethod) {
            ((PostMethod)httpMethod).setRequestEntity((RequestEntity)new StringRequestEntity(payload, "application/json", "UTF-8"));
        }
        this.client.executeMethod(httpMethod);
        if (this.isRedirect(httpMethod)) {
            Header newLocation = httpMethod.getResponseHeader("location");
            httpMethod = new GetMethod(newLocation.getValue());
            httpMethod.setFollowRedirects(true);
            httpMethod.addRequestHeader("Accept", "application/json, image/png");
            this.client.executeMethod(httpMethod);
        }
        return this.createResponse(httpMethod);
    }

    private Response createResponse(HttpMethod httpMethod) throws Exception {
        Response response;
        Header header = httpMethod.getResponseHeader("Content-Type");
        if (header != null && header.getValue().startsWith("application/json")) {
            response = (Response)new JsonToBeanConverter().convert(Response.class, (Object)httpMethod.getResponseBodyAsString());
        } else {
            int nextSlash;
            response = new Response();
            if (header != null && header.getValue().startsWith("image/png")) {
                response.setValue((Object)httpMethod.getResponseBody());
            } else {
                response.setValue((Object)httpMethod.getResponseBodyAsString());
            }
            String uri = httpMethod.getURI().toString();
            int sessionIndex = uri.indexOf("/session/");
            if (sessionIndex != -1 && (nextSlash = uri.indexOf("/", sessionIndex += "/session/".length())) != -1) {
                response.setSessionId(uri.substring(sessionIndex, nextSlash));
                response.setContext("foo");
            }
        }
        response.setError(httpMethod.getStatusCode() <= 199 || httpMethod.getStatusCode() >= 300);
        if (response.getValue() instanceof String) {
            response.setValue((Object)((String)response.getValue()).replace("\r\n", "\n"));
        }
        return response;
    }

    private boolean isRedirect(HttpMethod httpMethod) {
        int code = httpMethod.getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && httpMethod.getResponseHeader("location") != null;
    }

    private static class CommandInfo {
        private final String url;
        private final HttpVerb verb;

        public CommandInfo(String url, HttpVerb verb) {
            this.url = url;
            this.verb = verb;
        }

        public HttpMethod getMethod(String base, Command command) {
            StringBuilder urlBuilder = new StringBuilder(base);
            for (String part : this.url.split("/")) {
                if (part.length() == 0) continue;
                urlBuilder.append("/");
                if (part.startsWith(":")) {
                    String value = this.get(part.substring(1), command);
                    if (value == null) continue;
                    urlBuilder.append(this.get(part.substring(1), command));
                    continue;
                }
                urlBuilder.append(part);
            }
            return this.verb.createMethod(urlBuilder.toString());
        }

        private String get(String propertyName, Command command) {
            if ("sessionId".equals(propertyName)) {
                return command.getSessionId().toString();
            }
            if ("context".equals(propertyName)) {
                return command.getContext().toString();
            }
            if (command.getParameters().length > 0 && command.getParameters()[0] instanceof Map) {
                Object value = ((Map)command.getParameters()[0]).get(propertyName);
                if (value != null) {
                    try {
                        return URLEncoder.encode(String.valueOf(value), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return String.valueOf(value);
                    }
                }
                return null;
            }
            throw new IllegalArgumentException("Cannot determine property: " + propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HttpVerb {
        GET{

            public HttpMethod createMethod(String url) {
                GetMethod getMethod = new GetMethod(url);
                getMethod.setFollowRedirects(true);
                return getMethod;
            }
        }
        ,
        POST{

            public HttpMethod createMethod(String url) {
                return new PostMethod(url);
            }
        }
        ,
        DELETE{

            public HttpMethod createMethod(String url) {
                return new DeleteMethod(url);
            }
        };


        public abstract HttpMethod createMethod(String var1);
    }
}

