/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.ReturnedCookie;
import org.openqa.selenium.remote.Capabilities;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Context;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.MapMaker;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.RenderedRemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ScreenshotException;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWebDriver
implements WebDriver,
SearchContext,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByXPath {
    private CommandExecutor executor;
    private Capabilities capabilities;
    private SessionId sessionId;
    protected Process clientProcess;

    public RemoteWebDriver(CommandExecutor executor, Capabilities desiredCapabilities) {
        this.executor = executor;
        this.startClient();
        this.startSession(desiredCapabilities);
    }

    public RemoteWebDriver(Capabilities desiredCapabilities) throws Exception {
        this((URL)null, desiredCapabilities);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities desiredCapabilities) throws Exception {
        this(new HttpCommandExecutor(remoteAddress), desiredCapabilities);
    }

    protected void startSession(Capabilities desiredCapabilities) {
        Response response = this.execute("newSession", desiredCapabilities);
        Map rawCapabilities = (Map)response.getValue();
        String browser = (String)rawCapabilities.get("browserName");
        String version = (String)rawCapabilities.get("version");
        Platform platform = rawCapabilities.containsKey("operatingSystem") ? Platform.valueOf((String)((String)rawCapabilities.get("operatingSystem"))) : Platform.valueOf((String)((String)rawCapabilities.get("platform")));
        DesiredCapabilities returnedCapabilities = new DesiredCapabilities(browser, version, platform);
        returnedCapabilities.setJavascriptEnabled(((Boolean)rawCapabilities.get("javascriptEnabled")).booleanValue());
        this.capabilities = returnedCapabilities;
        this.sessionId = new SessionId(response.getSessionId());
    }

    protected void startClient() {
    }

    protected void stopClient() {
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void get(String url) {
        this.execute("get", url);
    }

    public String getTitle() {
        Response response = this.execute("getTitle", new Object[0]);
        return response.getValue().toString();
    }

    public String getCurrentUrl() {
        return this.execute("currentUrl", new Object[0]).getValue().toString();
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public WebElement findElementById(String using) {
        Response response = this.execute("findElement", "id", using);
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsById(String using) {
        Response response = this.execute("findElements", "id", using);
        return this.getElementsFrom(response);
    }

    public WebElement findElementByLinkText(String using) {
        Response response = this.execute("findElement", "link text", using);
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        Response response = this.execute("findElements", "link text", using);
        return this.getElementsFrom(response);
    }

    public WebElement findElementByPartialLinkText(String using) {
        Response response = this.execute("findElement", "partial link text", using);
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        Response response = this.execute("findElements", "partial link text", using);
        return this.getElementsFrom(response);
    }

    public WebElement findElementByName(String using) {
        Response response = this.execute("findElement", "name", using);
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByName(String using) {
        Response response = this.execute("findElements", "name", using);
        return this.getElementsFrom(response);
    }

    public WebElement findElementByClassName(String using) {
        Response response = this.execute("findElement", "class name", using);
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByClassName(String using) {
        Response response = this.execute("findElements", "class name", using);
        return this.getElementsFrom(response);
    }

    public WebElement findElementByXPath(String using) {
        Response response = this.execute("findElement", "xpath", using);
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByXPath(String using) {
        Response response = this.execute("findElements", "xpath", using);
        return this.getElementsFrom(response);
    }

    public String getPageSource() {
        return (String)this.execute("pageSource", new Object[0]).getValue();
    }

    public void close() {
        this.execute("close", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        try {
            this.execute("quit", new Object[0]);
        }
        finally {
            this.sessionId = null;
            this.stopClient();
        }
    }

    public Set<String> getWindowHandles() {
        Response response = this.execute("getWindowHandles", new Object[0]);
        List returnedValues = (List)response.getValue();
        return new LinkedHashSet<String>(returnedValues);
    }

    public String getWindowHandle() {
        return (String)this.execute("getCurrentWindowHandle", new Object[0]).getValue();
    }

    public Object executeScript(String script, Object ... args) {
        Map result;
        String type;
        Response response;
        if (!this.capabilities.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        Object[] convertedArgs = this.convertToJsObjects(args);
        Command command = convertedArgs != null && convertedArgs.length > 0 ? new Command(this.sessionId, new Context((Object)"foo"), "executeScript", new Object[]{script, convertedArgs}) : new Command(this.sessionId, new Context((Object)"foo"), "executeScript", new Object[]{script});
        try {
            response = this.executor.execute(command);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        if (response.isError()) {
            this.throwIfResponseFailed(response);
        }
        if ("NULL".equals(type = (String)(result = (Map)response.getValue()).get("type"))) {
            return null;
        }
        if ("ELEMENT".equals(type)) {
            String[] parts = ((String)result.get("value")).split("/");
            RemoteWebElement element = this.newRemoteWebElement();
            element.setId(parts[parts.length - 1]);
            return element;
        }
        if (result.get("value") instanceof Number) {
            if (result.get("value") instanceof Float || result.get("value") instanceof Double) {
                return ((Number)result.get("value")).doubleValue();
            }
            return ((Number)result.get("value")).longValue();
        }
        return result.get("value");
    }

    public boolean isJavascriptEnabled() {
        throw new UnsupportedOperationException("isJavascriptEnabled");
    }

    private Object[] convertToJsObjects(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        Object[] converted = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            converted[i] = this.convertToJsObject(args[i]);
        }
        return converted;
    }

    private Object convertToJsObject(Object arg) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        if (arg instanceof String) {
            converted.put("type", "STRING");
            converted.put("value", arg);
        } else if (arg instanceof Number) {
            converted.put("type", "NUMBER");
            if (arg instanceof Float || arg instanceof Double) {
                converted.put("value", ((Number)arg).doubleValue());
            } else {
                converted.put("value", ((Number)arg).longValue());
            }
        } else if (arg instanceof Boolean) {
            converted.put("type", "BOOLEAN");
            converted.put("value", (Boolean)arg);
        } else if (arg.getClass() == Boolean.TYPE) {
            converted.put("type", "BOOLEAN");
            converted.put("value", arg);
        } else if (arg instanceof RemoteWebElement) {
            converted.put("type", "ELEMENT");
            converted.put("value", ((RemoteWebElement)arg).getId());
        } else {
            if (arg instanceof Collection) {
                Collection args = (Collection)arg;
                Object[] list = new Object[args.size()];
                int i = 0;
                for (Object o : args) {
                    list[i] = this.convertToJsObject(o);
                    ++i;
                }
                return list;
            }
            throw new IllegalArgumentException("Argument is of an illegal type: " + arg);
        }
        return converted;
    }

    public WebDriver.TargetLocator switchTo() {
        return new RemoteTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new RemoteNavigation();
    }

    public WebDriver.Options manage() {
        return new RemoteWebDriverOptions();
    }

    protected WebElement getElementFrom(Response response) {
        List<WebElement> elements = this.getElementsFrom(response);
        return elements.get(0);
    }

    private RemoteWebElement newRemoteWebElement() {
        RemoteWebElement toReturn = this.capabilities.isJavascriptEnabled() ? new RenderedRemoteWebElement() : new RemoteWebElement();
        toReturn.setParent(this);
        return toReturn;
    }

    protected List<WebElement> getElementsFrom(Response response) {
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        List urls = (List)response.getValue();
        for (String url : urls) {
            String[] parts = url.split("/");
            RemoteWebElement element = this.newRemoteWebElement();
            element.setId(parts[parts.length - 1]);
            toReturn.add(element);
        }
        return toReturn;
    }

    protected Response execute(String commandName, Object ... parameters) {
        Command command = new Command(this.sessionId, new Context((Object)"foo"), commandName, parameters);
        Response response = new Response();
        try {
            response = this.executor.execute(command);
            this.amendElementValueIfNecessary(response);
        }
        catch (Exception e) {
            response.setError(true);
            response.setValue((Object)e.getStackTrace());
        }
        if (response.isError()) {
            return this.throwIfResponseFailed(response);
        }
        return response;
    }

    private void amendElementValueIfNecessary(Response response) {
        if (!(response.getValue() instanceof RemoteWebElement)) {
            return;
        }
        RemoteWebElement existingElement = (RemoteWebElement)response.getValue();
        existingElement.setParent(this);
        if (!this.getCapabilities().isJavascriptEnabled()) {
            return;
        }
        if (response.getValue() instanceof RenderedRemoteWebElement) {
            return;
        }
        RenderedRemoteWebElement replacement = new RenderedRemoteWebElement();
        replacement.setId(existingElement.getId());
        replacement.setParent(this);
        response.setValue((Object)replacement);
    }

    private Response throwIfResponseFailed(Response response) {
        Map rawException;
        if (response.getValue() instanceof StackTraceElement[]) {
            WebDriverException runtimeException = new WebDriverException();
            runtimeException.setStackTrace((StackTraceElement[])response.getValue());
            throw runtimeException;
        }
        try {
            rawException = (Map)response.getValue();
        }
        catch (ClassCastException e) {
            throw new RuntimeException(String.valueOf(response.getValue()));
        }
        String screenGrab = (String)rawException.get("screen");
        String message = (String)rawException.get("message");
        String className = (String)rawException.get("class");
        Object toThrow = null;
        try {
            List elements;
            Constructor<Object> constructor;
            Class<Object> aClass;
            try {
                aClass = Class.forName(className);
                if (!RuntimeException.class.isAssignableFrom(aClass)) {
                    aClass = WebDriverException.class;
                }
            }
            catch (ClassNotFoundException e) {
                aClass = WebDriverException.class;
            }
            if (screenGrab != null) {
                try {
                    constructor = aClass.getConstructor(String.class, Throwable.class);
                    toThrow = (RuntimeException)constructor.newInstance(new Object[]{message, new ScreenshotException(screenGrab)});
                }
                catch (NoSuchMethodException e) {
                }
                catch (OutOfMemoryError e) {
                    // empty catch block
                }
            }
            if (toThrow == null) {
                try {
                    constructor = aClass.getConstructor(String.class);
                    toThrow = (RuntimeException)constructor.newInstance(message);
                }
                catch (NoSuchMethodException e) {
                    toThrow = (WebDriverException)aClass.newInstance();
                }
            }
            if ((elements = (List)rawException.get("stackTrace")) != null) {
                StackTraceElement[] trace = new StackTraceElement[elements.size()];
                int lastInsert = 0;
                for (Map values : elements) {
                    Long lineNumber = (Long)values.get("lineNumber");
                    if (lineNumber == null) continue;
                    trace[lastInsert++] = new StackTraceElement((String)values.get("className"), (String)values.get("methodName"), (String)values.get("fileName"), (int)lineNumber.longValue());
                }
                if (lastInsert == elements.size()) {
                    ((Throwable)toThrow).setStackTrace(trace);
                }
            }
        }
        catch (Exception e) {
            toThrow = new WebDriverException((Throwable)e);
        }
        throw toThrow;
    }

    private class RemoteTargetLocator
    implements WebDriver.TargetLocator {
        private RemoteTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            RemoteWebDriver.this.execute("switchToFrame", MapMaker.map("id", frameIndex));
            return RemoteWebDriver.this;
        }

        public WebDriver frame(String frameName) {
            RemoteWebDriver.this.execute("switchToFrame", MapMaker.map("id", frameName));
            return RemoteWebDriver.this;
        }

        public WebDriver window(String windowName) {
            RemoteWebDriver.this.execute("switchToWindow", MapMaker.map("name", windowName));
            return RemoteWebDriver.this;
        }

        public WebDriver defaultContent() {
            RemoteWebDriver.this.execute("switchToFrame", MapMaker.map("id", null));
            return RemoteWebDriver.this;
        }

        public WebElement activeElement() {
            Response response = RemoteWebDriver.this.execute("getActiveElement", new Object[0]);
            return RemoteWebDriver.this.getElementFrom(response);
        }
    }

    private class RemoteNavigation
    implements WebDriver.Navigation {
        private RemoteNavigation() {
        }

        public void back() {
            RemoteWebDriver.this.execute("back", new Object[0]);
        }

        public void forward() {
            RemoteWebDriver.this.execute("forward", new Object[0]);
        }

        public void to(String url) {
            RemoteWebDriver.this.get(url);
        }

        public void to(URL url) {
            RemoteWebDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            RemoteWebDriver.this.execute("refresh", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteWebDriverOptions
    implements WebDriver.Options {
        private RemoteWebDriverOptions() {
        }

        public void addCookie(Cookie cookie) {
            RemoteWebDriver.this.execute("addCookie", cookie);
        }

        public void deleteCookieNamed(String name) {
            RemoteWebDriver.this.execute("deleteCookie", MapMaker.map("name", name));
        }

        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteAllCookies() {
            RemoteWebDriver.this.execute("deleteAllCookies", new Object[0]);
        }

        public Set<Cookie> getCookies() {
            Object returned = RemoteWebDriver.this.execute("getAllCookies", new Object[0]).getValue();
            try {
                List cookies = (List)new JsonToBeanConverter().convert(List.class, returned);
                HashSet<Cookie> toReturn = new HashSet<Cookie>();
                for (Map rawCookie : cookies) {
                    String name = (String)rawCookie.get("name");
                    String value = (String)rawCookie.get("value");
                    String path = (String)rawCookie.get("path");
                    String domain = (String)rawCookie.get("domain");
                    Boolean secure = (Boolean)rawCookie.get("secure");
                    toReturn.add((Cookie)new ReturnedCookie(name, value, domain, path, null, secure.booleanValue()));
                }
                return toReturn;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public Speed getSpeed() {
            Response response = RemoteWebDriver.this.execute("getSpeed", new Object[0]);
            return Speed.valueOf((String)((String)response.getValue()));
        }

        public void setSpeed(Speed speed) {
            RemoteWebDriver.this.execute("setSpeed", speed);
        }
    }
}

