/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Context;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonToBeanConverter {
    public <T> T convert(Class<T> clazz, Object text) throws Exception {
        JSONObject o;
        if (text == null) {
            return null;
        }
        if (String.class.equals(clazz)) {
            return (T)text;
        }
        if (this.isPrimitive(clazz)) {
            return (T)text;
        }
        if (text instanceof Number) {
            if (text instanceof Double || text instanceof Float) {
                return (T)Double.valueOf(String.valueOf(text));
            }
            return (T)Long.valueOf(String.valueOf(text));
        }
        if (this.isPrimitive(text.getClass())) {
            return (T)text;
        }
        if (this.isEnum(clazz, text)) {
            return (T)this.convertEnum(clazz, text);
        }
        if ("".equals(String.valueOf(text))) {
            return (T)text;
        }
        if (Command.class.equals(clazz)) {
            JSONObject rawCommand = new JSONObject((String)text);
            SessionId sessionId = null;
            if (rawCommand.has("sessionId")) {
                sessionId = this.convert(SessionId.class, rawCommand.getString("sessionId"));
            }
            Context context = null;
            if (rawCommand.has("context")) {
                context = this.convert(Context.class, rawCommand.getString("context"));
            }
            if (rawCommand.has("parameters")) {
                List args = this.convert(ArrayList.class, rawCommand.getJSONArray("parameters"));
                return (T)new Command(sessionId, context, rawCommand.getString("methodName"), args.toArray());
            }
            return (T)new Command(sessionId, context, rawCommand.getString("methodName"), new Object[0]);
        }
        if (Context.class.equals(clazz)) {
            JSONObject object = new JSONObject((String)text);
            String value = object.getString("value");
            return (T)new Context(value);
        }
        if (SessionId.class.equals(clazz)) {
            JSONObject object = new JSONObject((String)text);
            String value = object.getString("value");
            return (T)new SessionId(value);
        }
        if (text != null && text instanceof String && !((String)text).startsWith("{") && Object.class.equals(clazz)) {
            return (T)text;
        }
        if (text instanceof JSONArray) {
            return (T)this.convertList((JSONArray)text);
        }
        try {
            if (text instanceof JSONObject) {
                o = (JSONObject)text;
            } else if (text != null && text instanceof String && ((String)text).startsWith("[")) {
                return (T)this.convert(List.class, new JSONArray((String)text));
            }
            o = new JSONObject(String.valueOf(text));
        }
        catch (JSONException e) {
            return (T)text;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return (T)this.convertMap(o);
        }
        if (this.isPrimitive(o.getClass())) {
            return (T)o;
        }
        if (Object.class.equals(clazz)) {
            return (T)this.convertMap(o);
        }
        return this.convertBean(clazz, o);
    }

    private Enum convertEnum(Class clazz, Object text) {
        Class<?>[] allClasses;
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, String.valueOf(text));
        }
        for (Class<?> current : allClasses = clazz.getClasses()) {
            if (!current.isEnum()) continue;
            return Enum.valueOf(current, String.valueOf(text));
        }
        return null;
    }

    private boolean isEnum(Class<?> clazz, Object text) {
        return clazz.isEnum() || text instanceof Enum;
    }

    private Object convert(Object toConvert) throws Exception {
        return toConvert;
    }

    public <T> T convertBean(Class<T> clazz, JSONObject toConvert) throws Exception {
        PropertyDescriptor[] allProperties;
        T t = clazz.newInstance();
        for (PropertyDescriptor property : allProperties = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (!toConvert.has(property.getName())) continue;
            Object value = toConvert.get(property.getName());
            Method write = property.getWriteMethod();
            if (write == null) continue;
            Class<?> type = write.getParameterTypes()[0];
            try {
                write.invoke(t, this.convert(type, value));
            }
            catch (Exception e) {
                throw new Exception(String.format("Property name: %s -> %s on class %s", property.getName(), value, type), e);
            }
        }
        return t;
    }

    private Map convertMap(JSONObject toConvert) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator allEntries = toConvert.keys();
        while (allEntries.hasNext()) {
            String key = (String)allEntries.next();
            map.put(key, this.convert(Object.class, toConvert.get(key)));
        }
        return map;
    }

    private List convertList(JSONArray toConvert) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(toConvert.length());
        for (int i = 0; i < toConvert.length(); ++i) {
            list.add(this.convert(Object.class, toConvert.get(i)));
        }
        return list;
    }

    private boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Void.class.isAssignableFrom(clazz);
    }
}

