/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import com.thoughtworks.selenium.SeleniumException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.ExactTextMatchingStrategy;
import org.openqa.selenium.internal.GlobTextMatchingStrategy;
import org.openqa.selenium.internal.LookupStrategy;
import org.openqa.selenium.internal.RegExTextMatchingStrategy;
import org.openqa.selenium.internal.TextMatchingStrategy;

public class LinkLookupStrategy
implements LookupStrategy {
    private static final Pattern TEXT_MATCHING_STRATEGY_AND_VALUE_PATTERN = Pattern.compile("^(\\p{Alpha}+):(.*)");
    private Map<String, TextMatchingStrategy> textMatchingStrategies = new HashMap<String, TextMatchingStrategy>();

    public LinkLookupStrategy() {
        this.textMatchingStrategies.put("implicit", new GlobTextMatchingStrategy());
        this.textMatchingStrategies.put("glob", new GlobTextMatchingStrategy());
        this.textMatchingStrategies.put("regexp", new RegExTextMatchingStrategy());
        this.textMatchingStrategies.put("exact", new ExactTextMatchingStrategy());
    }

    public WebElement find(WebDriver driver, String use) {
        List elements = driver.findElements(By.xpath((String)"//a"));
        String strategyName = "implicit";
        Matcher matcher = TEXT_MATCHING_STRATEGY_AND_VALUE_PATTERN.matcher(use);
        if (matcher.matches()) {
            strategyName = matcher.group(1);
            use = matcher.group(2);
        }
        TextMatchingStrategy strategy = this.textMatchingStrategies.get(strategyName);
        Iterator allLinks = elements.iterator();
        while (allLinks.hasNext()) {
            WebElement link = (WebElement)allLinks.next();
            if (strategy.isAMatch(use, link.getText())) continue;
            allLinks.remove();
        }
        if (elements.size() > 0) {
            return (WebElement)elements.get(0);
        }
        throw new SeleniumException(use + " not found");
    }
}

