/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import com.thoughtworks.selenium.SeleniumException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FilterFunction;
import org.openqa.selenium.internal.IndexFilterFunction;
import org.openqa.selenium.internal.LookupStrategy;
import org.openqa.selenium.internal.NameFilterFunction;
import org.openqa.selenium.internal.ValueFilterFunction;

public class NameLookupStrategy
implements LookupStrategy {
    private static final Pattern NAME_AND_VALUE_PATTERN = Pattern.compile("^(\\p{Alpha}+)=(.+)");
    Map<String, FilterFunction> filterFunctions = new HashMap<String, FilterFunction>();

    public NameLookupStrategy() {
        this.filterFunctions.put("value", new ValueFilterFunction());
        this.filterFunctions.put("name", new NameFilterFunction());
        this.filterFunctions.put("index", new IndexFilterFunction());
    }

    public WebElement find(WebDriver driver, String use) {
        String[] parts = use.split(" ");
        List<WebElement> allElements = driver.findElements(By.name((String)parts[0]));
        Iterator iterator = allElements.iterator();
        while (iterator.hasNext()) {
            WebElement element = (WebElement)iterator.next();
            if (parts[0].equals(element.getAttribute("name"))) continue;
            iterator.remove();
        }
        for (int i = 1; i < parts.length; ++i) {
            FilterFunction filterBy = this.getFilterFunction(parts[i]);
            if (filterBy == null) {
                throw new SeleniumException(use + " not found. Cannot find filter for: " + parts[i]);
            }
            String filterValue = this.getFilterValue(parts[i]);
            allElements = filterBy.filterElements(allElements, filterValue);
        }
        if (allElements.size() > 0) {
            return (WebElement)allElements.get(0);
        }
        throw new SeleniumException(use + " not found");
    }

    private String getFilterValue(String originalFilterValue) {
        Matcher matcher = NAME_AND_VALUE_PATTERN.matcher(originalFilterValue);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return originalFilterValue;
    }

    private FilterFunction getFilterFunction(String originalFilter) {
        String filterName = "value";
        Matcher matcher = NAME_AND_VALUE_PATTERN.matcher(originalFilter);
        if (matcher.matches()) {
            filterName = matcher.group(1);
        }
        return this.filterFunctions.get(filterName);
    }
}

