/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.excel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.SeriesTextRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String END_OF_LINE = System.getProperty("line.separator", "\n");

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        PoiUtil.extractAll(inputStream, new ExcelTextExtractor(), rDFContainer, this.logger);
        rDFContainer.add(RDF.type, (Node)NFO.Spreadsheet);
    }

    private static class ExcelEventListener
    implements HSSFListener {
        private SSTRecord sstrec;
        private StringBuilder buffer = new StringBuilder(65536);

        private ExcelEventListener() {
        }

        public void processRecord(Record record) {
            switch (record.getSid()) {
                case 133: {
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    String string = boundSheetRecord.getSheetname();
                    if (string == null) break;
                    this.buffer.append(END_OF_LINE);
                    this.buffer.append(string);
                    this.buffer.append(END_OF_LINE);
                    this.buffer.append(END_OF_LINE);
                    break;
                }
                case 515: {
                    NumberRecord numberRecord = (NumberRecord)record;
                    this.buffer.append(numberRecord.getValue());
                    this.buffer.append(' ');
                    break;
                }
                case 252: {
                    this.sstrec = (SSTRecord)record;
                    break;
                }
                case 253: {
                    UnicodeString unicodeString;
                    LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                    if (this.sstrec == null || (unicodeString = this.sstrec.getString(labelSSTRecord.getSSTIndex())) == null) break;
                    this.append(unicodeString.toString(), this.buffer);
                    break;
                }
                case 519: {
                    StringRecord stringRecord = (StringRecord)record;
                    this.append(stringRecord.getString(), this.buffer);
                    break;
                }
                case 20: {
                    HeaderRecord headerRecord = (HeaderRecord)record;
                    this.append(headerRecord.getHeader(), this.buffer);
                    break;
                }
                case 21: {
                    FooterRecord footerRecord = (FooterRecord)record;
                    this.append(footerRecord.getFooter(), this.buffer);
                    break;
                }
                case 24: {
                    NameRecord nameRecord = (NameRecord)record;
                    this.append(nameRecord.getNameText(), this.buffer);
                    this.append(nameRecord.getDescriptionText(), this.buffer);
                    break;
                }
                case 4109: {
                    SeriesTextRecord seriesTextRecord = (SeriesTextRecord)record;
                    this.append(seriesTextRecord.getText(), this.buffer);
                }
            }
        }

        private void append(String string, StringBuilder stringBuilder) {
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
        }

        public String getText() {
            return this.buffer.toString().trim();
        }
    }

    private static class ExcelTextExtractor
    implements PoiUtil.TextExtractor {
        private ExcelTextExtractor() {
        }

        public String getText(POIFSFileSystem pOIFSFileSystem) throws IOException {
            DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
            HSSFRequest hSSFRequest = new HSSFRequest();
            ExcelEventListener excelEventListener = new ExcelEventListener();
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)133);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)515);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)252);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)253);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)519);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)20);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)21);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)24);
            hSSFRequest.addListener((HSSFListener)excelEventListener, (short)4109);
            HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
            hSSFEventFactory.processEvents(hSSFRequest, (InputStream)documentInputStream);
            documentInputStream.close();
            return excelEventListener.getText();
        }
    }
}

